/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.swing.editors.ColorPropertyEditor;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class LinearGradientPaintPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        LinearGradientPaint p = (LinearGradientPaint)this.getValue();
        return p.getStartPoint().getX() + ", " + p.getStartPoint().getY() + ", " + p.getEndPoint().getX() + ", " + p.getEndPoint().getY() + ", " + this.formatFractions(p.getFractions()) + ", " + this.formatColors(p.getColors()) + ", " + p.getCycleMethod().name();
    }

    private String formatFractions(float[] fractions) {
        StringBuilder b = new StringBuilder("[");
        boolean first = true;
        for (float f : fractions) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(f);
        }
        return b.append("]").toString();
    }

    private String formatColors(Color[] colors) {
        StringBuilder b = new StringBuilder("[");
        boolean first = true;
        for (Color c : colors) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(ColorPropertyEditor.format(c));
        }
        return b.append("]").toString();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof LinearGradientPaint) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, LinearGradientPaint.class);
        }
    }

    private void handleAsString(String str) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float[] fractions = null;
        Color[] colors = null;
        MultipleGradientPaint.CycleMethod cyclicMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        String[] parts = str.split(",");
        switch (parts.length) {
            case 7: {
                cyclicMethod = this.parseCyclicMethod(str, parts[6]);
            }
            case 6: {
                x1 = this.parseValue(parts[0]);
                y1 = this.parseValue(parts[1]);
                x2 = this.parseValue(parts[2]);
                y2 = this.parseValue(parts[3]);
                fractions = this.parseFractions((Object)str, parts[4].trim());
                colors = this.parseColors((Object)str, parts[5].trim());
                if (fractions.length != colors.length) {
                    throw this.illegalValue(str, LinearGradientPaint.class);
                }
                super.setValueInternal((Object)new LinearGradientPaint(x1, y1, x2, y2, fractions, colors, cyclicMethod));
                break;
            }
            default: {
                throw this.illegalValue(str, LinearGradientPaint.class);
            }
        }
    }

    private void handleAsList(List list) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float[] fractions = null;
        Color[] colors = null;
        MultipleGradientPaint.CycleMethod cyclicMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        switch (list.size()) {
            case 7: {
                cyclicMethod = this.parseCyclicMethod(list, String.valueOf(list.get(6)).trim());
            }
            case 6: {
                x1 = this.parseValue(list.get(0));
                y1 = this.parseValue(list.get(1));
                x2 = this.parseValue(list.get(2));
                y2 = this.parseValue(list.get(3));
                fractions = this.parseFractions((Object)list, list.get(4));
                colors = this.parseColors((Object)list, list.get(5));
                if (fractions.length != colors.length) {
                    throw this.illegalValue(list, LinearGradientPaint.class);
                }
                super.setValueInternal((Object)new LinearGradientPaint(x1, y1, x2, y2, fractions, colors, cyclicMethod));
                break;
            }
            default: {
                throw this.illegalValue(list, LinearGradientPaint.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        Color[] colors;
        float x1 = ((Float)this.getMapValue(map, "x1", Float.valueOf(0.0f))).floatValue();
        float y1 = ((Float)this.getMapValue(map, "y1", Float.valueOf(0.0f))).floatValue();
        float x2 = ((Float)this.getMapValue(map, "x2", Float.valueOf(0.0f))).floatValue();
        float y2 = ((Float)this.getMapValue(map, "y2", Float.valueOf(0.0f))).floatValue();
        MultipleGradientPaint.CycleMethod cyclicMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        float[] fractions = this.parseFractions((Object)map, map.get("fractions"));
        if (fractions.length != (colors = this.parseColors((Object)map, map.get("colors"))).length) {
            throw this.illegalValue(map, LinearGradientPaint.class);
        }
        Object cyclicValue = map.get("cyclic");
        if (null != cyclicValue) {
            cyclicMethod = this.parseCyclicMethod(map, String.valueOf(cyclicValue));
        }
        super.setValueInternal((Object)new LinearGradientPaint(x1, y1, x2, y2, fractions, colors, cyclicMethod));
    }

    private float[] parseFractions(Object source, Object obj) {
        if (obj instanceof CharSequence) {
            return this.parseFractions(source, String.valueOf(obj).trim());
        }
        if (obj instanceof List) {
            return this.parseFractions(source, (List)obj);
        }
        throw this.illegalValue(source, LinearGradientPaint.class);
    }

    private float[] parseFractions(Object source, String str) {
        if (str.startsWith("[") && str.endsWith("]")) {
            throw this.illegalValue(source, LinearGradientPaint.class);
        }
        String[] strs = str.substring(1, str.length() - 2).split(",");
        float[] fractions = new float[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            fractions[i] = this.parseValue(strs[i]);
        }
        return fractions;
    }

    private float[] parseFractions(Object source, List list) {
        float[] fractions = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            fractions[i] = this.parseValue(list.get(1));
        }
        return fractions;
    }

    private Color[] parseColors(Object source, Object obj) {
        if (obj instanceof CharSequence) {
            return this.parseColors(source, String.valueOf(obj).trim());
        }
        if (obj instanceof List) {
            return this.parseColors(source, (List)obj);
        }
        throw this.illegalValue(source, LinearGradientPaint.class);
    }

    private Color[] parseColors(Object source, String str) {
        if (str.startsWith("[") && str.endsWith("]")) {
            throw this.illegalValue(source, LinearGradientPaint.class);
        }
        String[] strs = str.substring(1, str.length() - 2).split(",");
        Color[] colors = new Color[strs.length];
        ColorPropertyEditor colorEditor = new ColorPropertyEditor();
        for (int i = 0; i < strs.length; ++i) {
            try {
                colorEditor.setValueInternal(strs[i]);
                colors[i] = (Color)colorEditor.getValue();
                continue;
            }
            catch (Exception e) {
                throw this.illegalValue(strs[i], LinearGradientPaint.class);
            }
        }
        return colors;
    }

    private Color[] parseColors(Object source, List list) {
        Color[] colors = new Color[list.size()];
        ColorPropertyEditor colorEditor = new ColorPropertyEditor();
        for (int i = 0; i < list.size(); ++i) {
            try {
                colorEditor.setValueInternal(list.get(i));
                colors[i] = (Color)colorEditor.getValue();
                continue;
            }
            catch (Exception e) {
                throw this.illegalValue(list.get(i), LinearGradientPaint.class);
            }
        }
        return colors;
    }

    private MultipleGradientPaint.CycleMethod parseCyclicMethod(Object source, String str) {
        try {
            Field cyclicMethodField = MultipleGradientPaint.CycleMethod.class.getDeclaredField(str.toUpperCase().trim());
            return (MultipleGradientPaint.CycleMethod)((Object)cyclicMethodField.get(null));
        }
        catch (NoSuchFieldException e) {
            throw this.illegalValue(source, LinearGradientPaint.class, e);
        }
        catch (IllegalAccessException e) {
            throw this.illegalValue(source, LinearGradientPaint.class, e);
        }
    }

    private float parse(String val) {
        try {
            return Float.parseFloat(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, LinearGradientPaint.class, e);
        }
    }

    private float parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, LinearGradientPaint.class);
    }

    private float parse(Number val) {
        return val.floatValue();
    }

    private Object getMapValue(Map map, String key, Object defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return Float.valueOf(this.parse(String.valueOf(val)));
        }
        if (val instanceof Number) {
            return Float.valueOf(this.parse((Number)val));
        }
        throw this.illegalValue(map, LinearGradientPaint.class);
    }
}

