/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.awt.Insets;
import java.util.List;
import java.util.Map;

public class InsetsPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Insets i = (Insets)this.getValue();
        return i.top + ", " + i.left + ", " + i.bottom + ", " + i.right;
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Insets) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Insets.class);
        }
    }

    private void handleAsString(String str) {
        int t = 0;
        int l = 0;
        int r = 0;
        int b = 0;
        String[] parts = str.split(",");
        switch (parts.length) {
            case 4: {
                b = this.parseValue(parts[3]);
            }
            case 3: {
                r = this.parseValue(parts[2]);
            }
            case 2: {
                l = this.parseValue(parts[1]);
            }
            case 1: {
                t = this.parseValue(parts[0]);
                super.setValueInternal((Object)new Insets(t, l, r, b));
                break;
            }
            default: {
                throw this.illegalValue(str, Insets.class);
            }
        }
    }

    private void handleAsList(List list) {
        int t = 0;
        int l = 0;
        int r = 0;
        int b = 0;
        switch (list.size()) {
            case 4: {
                b = this.parseValue(list.get(3));
            }
            case 3: {
                r = this.parseValue(list.get(2));
            }
            case 2: {
                l = this.parseValue(list.get(1));
            }
            case 1: {
                t = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Insets(t, l, r, b));
                break;
            }
            default: {
                throw this.illegalValue(list, Insets.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        int t = this.getMapValue(map, "top", 0);
        int l = this.getMapValue(map, "left", 0);
        int r = this.getMapValue(map, "right", 0);
        int b = this.getMapValue(map, "bottom", 0);
        super.setValueInternal((Object)new Insets(t, l, r, b));
    }

    private int parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Insets.class);
    }

    private int parse(String val) {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Insets.class, e);
        }
    }

    private int parse(Number val) {
        return val.intValue();
    }

    private int getMapValue(Map map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Insets.class);
    }

    private void handleAsNumber(Number value) {
        int c = this.parse(value);
        super.setValueInternal((Object)new Insets(c, c, c, c));
    }
}

