/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class ImagePropertyEditor
extends AbstractPropertyEditor {
    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URL) {
            this.handleAsURL((URL)value);
        } else if (value instanceof URI) {
            this.handleAsURI((URI)value);
        } else if (value instanceof InputStream) {
            this.handleAsInputStream((InputStream)value);
        } else if (value instanceof ImageInputStream) {
            this.handleAsImageInputStream((ImageInputStream)value);
        } else if (value instanceof byte[]) {
            this.handleAsByteArray((byte[])value);
        } else if (value instanceof Image) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Image.class);
        }
    }

    private void handleAsString(String str) {
        this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(str));
    }

    private void handleAsFile(File file) {
        try {
            super.setValueInternal((Object)ImageIO.read(file));
        }
        catch (IOException e) {
            throw this.illegalValue(file, Image.class);
        }
    }

    private void handleAsURL(URL url) {
        try {
            super.setValueInternal((Object)ImageIO.read(url));
        }
        catch (IOException e) {
            throw this.illegalValue(url, Image.class);
        }
    }

    private void handleAsURI(URI uri) {
        try {
            this.handleAsURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(uri, Image.class);
        }
    }

    private void handleAsInputStream(InputStream stream) {
        try {
            super.setValueInternal((Object)ImageIO.read(stream));
        }
        catch (IOException e) {
            throw this.illegalValue(stream, Image.class);
        }
    }

    private void handleAsImageInputStream(ImageInputStream stream) {
        try {
            super.setValueInternal((Object)ImageIO.read(stream));
        }
        catch (IOException e) {
            throw this.illegalValue(stream, Image.class);
        }
    }

    private void handleAsByteArray(byte[] bytes) {
        super.setValueInternal((Object)Toolkit.getDefaultToolkit().createImage(bytes));
    }
}

