/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing;

import griffon.core.ApplicationPhase;
import griffon.core.GriffonApplication;
import griffon.core.ShutdownHandler;
import griffon.swing.SwingGriffonApplication;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowManager
implements ShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WindowManager.class);
    private final SwingGriffonApplication app;
    private final WindowHelper windowHelper = new WindowHelper();
    private final ComponentHelper componentHelper = new ComponentHelper();
    private final InternalFrameHelper internalFrameHelper = new InternalFrameHelper();
    private final List<Window> windows = new CopyOnWriteArrayList<Window>();
    private final List<JInternalFrame> internalFrames = new CopyOnWriteArrayList<JInternalFrame>();
    private boolean hideBeforeHandler = false;

    public WindowManager(SwingGriffonApplication app) {
        this.app = app;
    }

    public Window findWindow(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            for (Window window : this.windows) {
                if (!name.equals(window.getName())) continue;
                return window;
            }
        }
        return null;
    }

    public JInternalFrame findInternalFrame(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            for (JInternalFrame internalFrame : this.internalFrames) {
                if (!name.equals(internalFrame.getName())) continue;
                return internalFrame;
            }
        }
        return null;
    }

    public Window getAt(int index) {
        return this.windows.get(index);
    }

    public Window getStartingWindow() {
        int index;
        Window window = null;
        Object value = ConfigUtils.getConfigValue((Map)this.app.getConfig(), (String)"swing.windowManager.startingWindow");
        if (LOG.isDebugEnabled()) {
            LOG.debug("swing.windowManager.startingWindow configured to " + value);
        }
        if (value == null || value instanceof ConfigObject) {
            if (this.windows.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No startingWindow configured, selecting the first one in the list of windows");
                }
                window = this.windows.get(0);
            }
        } else if (value instanceof String) {
            String windowName = (String)value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window " + windowName + " as starting window");
            }
            window = this.findWindow(windowName);
        } else if (value instanceof Number && (index = ((Number)value).intValue()) >= 0 && index < this.windows.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window at index " + index + " as starting window");
            }
            window = this.windows.get(index);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting Window is " + window);
        }
        return window;
    }

    public List<Window> getWindows() {
        return Collections.unmodifiableList(this.windows);
    }

    public List<JInternalFrame> getInternalFrames() {
        return Collections.unmodifiableList(this.internalFrames);
    }

    public void attach(Window window) {
        if (window == null || this.windows.contains(window)) {
            return;
        }
        window.addWindowListener(this.windowHelper);
        window.addComponentListener(this.componentHelper);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attaching window with name: '" + window.getName() + "' at index " + this.windows.size() + " " + window);
        }
        this.windows.add(window);
    }

    public void attach(JInternalFrame internalFrame) {
        if (internalFrame == null || this.internalFrames.contains(internalFrame)) {
            return;
        }
        internalFrame.addInternalFrameListener(this.internalFrameHelper);
        internalFrame.setDefaultCloseOperation(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attaching internal frame with name: '" + internalFrame.getName() + "' at index " + this.internalFrames.size() + " " + internalFrame);
        }
        this.internalFrames.add(internalFrame);
    }

    public void detach(Window window) {
        if (window == null) {
            return;
        }
        if (this.windows.contains(window)) {
            window.removeWindowListener(this.windowHelper);
            window.removeComponentListener(this.componentHelper);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detaching window with name: '" + window.getName() + "' at index " + this.windows.indexOf(window) + " " + window);
            }
            this.windows.remove(window);
        }
    }

    public void detach(JInternalFrame internalFrame) {
        if (internalFrame == null) {
            return;
        }
        if (this.internalFrames.contains(internalFrame)) {
            internalFrame.removeInternalFrameListener(this.internalFrameHelper);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detaching internal frame with name: '" + internalFrame.getName() + "' at index " + this.internalFrames.indexOf(internalFrame) + " " + internalFrame);
            }
            this.internalFrames.remove(internalFrame);
        }
    }

    public void show(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Showing window with name: '" + window.getName() + "' at index " + WindowManager.this.windows.indexOf(window) + " " + window);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().show(window, (GriffonApplication)WindowManager.this.app);
            }
        });
    }

    public void show(final JInternalFrame internalFrame) {
        if (internalFrame == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Showing internalFrame with name: '" + internalFrame.getName() + " " + internalFrame);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().show(internalFrame, (GriffonApplication)WindowManager.this.app);
            }
        });
    }

    public void show(String name) {
        Window window = this.findWindow(name);
        if (window != null) {
            this.show(window);
        } else {
            JInternalFrame frame = this.findInternalFrame(name);
            if (frame != null) {
                this.show(frame);
            }
        }
    }

    public void hide(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hiding window with name: '" + window.getName() + "' at index " + WindowManager.this.windows.indexOf(window) + " " + window);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().hide(window, (GriffonApplication)WindowManager.this.app);
            }
        });
    }

    public void hide(final JInternalFrame internalFrame) {
        if (internalFrame == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hiding internal frame with name: '" + internalFrame.getName() + " " + internalFrame);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().hide(internalFrame, (GriffonApplication)WindowManager.this.app);
            }
        });
    }

    public void hide(String name) {
        Window window = this.findWindow(name);
        if (window != null) {
            this.hide(window);
        } else {
            JInternalFrame frame = this.findInternalFrame(name);
            if (frame != null) {
                this.hide(frame);
            }
        }
    }

    public boolean canShutdown(GriffonApplication app) {
        return true;
    }

    public void onShutdown(GriffonApplication app) {
        for (Window window : this.windows) {
            if (!window.isVisible()) continue;
            this.hide(window);
        }
    }

    public boolean isHideBeforeHandler() {
        return this.hideBeforeHandler;
    }

    public void setHideBeforeHandler(boolean hideBeforeHandler) {
        this.hideBeforeHandler = hideBeforeHandler;
    }

    public int countVisibleWindows() {
        int visibleWindows = 0;
        for (Window window : this.windows) {
            if (!window.isVisible()) continue;
            ++visibleWindows;
        }
        return visibleWindows;
    }

    public boolean isAutoShutdown() {
        Boolean autoShutdown = (Boolean)this.app.getConfig().flatten().get("application.autoShutdown");
        return autoShutdown == null || autoShutdown != false;
    }

    private class InternalFrameHelper
    extends InternalFrameAdapter {
        private InternalFrameHelper() {
        }

        public void internalFrameClosing(InternalFrameEvent event) {
            WindowManager.this.hide(event.getInternalFrame());
        }

        public void internalFrameOpened(InternalFrameEvent event) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_SHOWN.getName(), Arrays.asList(event.getSource()));
        }

        public void internalFrameClosed(InternalFrameEvent event) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_HIDDEN.getName(), Arrays.asList(event.getSource()));
        }
    }

    private class ComponentHelper
    extends ComponentAdapter {
        private ComponentHelper() {
        }

        public void componentShown(ComponentEvent event) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_SHOWN.getName(), Arrays.asList(event.getSource()));
        }

        public void componentHidden(ComponentEvent event) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_HIDDEN.getName(), Arrays.asList(event.getSource()));
        }
    }

    private class WindowHelper
    extends WindowAdapter {
        private WindowHelper() {
        }

        public void windowClosing(WindowEvent event) {
            if (WindowManager.this.app.getPhase() == ApplicationPhase.SHUTDOWN) {
                return;
            }
            int visibleWindows = WindowManager.this.countVisibleWindows();
            if (WindowManager.this.isHideBeforeHandler() || visibleWindows > 0) {
                WindowManager.this.hide(event.getWindow());
            }
            if (visibleWindows <= 1 && WindowManager.this.isAutoShutdown()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attempting to shutdown application");
                }
                if (!WindowManager.this.app.shutdown()) {
                    WindowManager.this.show(event.getWindow());
                }
            }
        }
    }
}

