/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing;

import griffon.core.GriffonApplication;
import griffon.util.ConfigUtils;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

public class SwingUtils {
    public static void centerOnScreen(Window window) {
        if (window == null) {
            return;
        }
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        double w = Math.min(window.getWidth(), screen.width);
        double h = Math.min(window.getHeight(), screen.height);
        int x = (int)((double)center.x - w / 2.0);
        int y = (int)((double)center.y - h / 2.0);
        Point corner = new Point(x >= 0 ? x : 0, y >= 0 ? y : 0);
        window.setLocation(corner);
    }

    public static void centerOnScreen(JInternalFrame internalFrame) {
        if (internalFrame == null) {
            return;
        }
        JDesktopPane desktop = internalFrame.getDesktopPane();
        if (desktop == null) {
            return;
        }
        Dimension screen = desktop.getSize();
        Point center = new Point(screen.width / 2, screen.height / 2);
        double w = Math.min(internalFrame.getWidth(), screen.width);
        double h = Math.min(internalFrame.getHeight(), screen.height);
        int x = (int)((double)center.x - w / 2.0);
        int y = (int)((double)center.y - h / 2.0);
        Point corner = new Point(x >= 0 ? x : 0, y >= 0 ? y : 0);
        internalFrame.setLocation(corner);
    }

    public static Window createApplicationFrame(GriffonApplication app) {
        ClassLoader cl;
        JFrame frame = null;
        String frameClass = (String)ConfigUtils.getConfigValue((Map)app.getConfig(), (String)"application.frameClass");
        if (!GriffonNameUtils.isBlank((String)frameClass)) {
            try {
                cl = SwingUtils.class.getClassLoader();
                frame = cl != null ? (JFrame)cl.loadClass(frameClass).newInstance() : (JFrame)Class.forName(frameClass).newInstance();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (frame == null) {
            try {
                cl = SwingUtils.class.getClassLoader();
                frame = cl != null ? (JFrame)cl.loadClass("org.jdesktop.swingx.JXFrame").newInstance() : (JFrame)Class.forName("org.jdesktop.swingx.JXFrame").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (frame == null) {
                frame = new JFrame();
            }
            frame.setDefaultCloseOperation(0);
        }
        return frame;
    }

    public static boolean isTranslucencySupported() {
        if (GriffonApplicationUtils.isJdk17()) {
            return true;
        }
        if (GriffonApplicationUtils.isJdk16()) {
            Class awtUtilities = SwingUtils.loadClass("com.sun.awt.AWTUtilities");
            Class translucency = SwingUtils.loadClass("com.sun.awt.AWTUtilities$Translucency");
            return (Boolean)GriffonClassUtils.invokeStaticMethod((Class)awtUtilities, (String)"isTranslucencySupported", Enum.valueOf(translucency, "TRANSLUCENT"));
        }
        return false;
    }

    public static float getWindowOpacity(Window window) {
        Float value = Float.valueOf(1.0f);
        if (GriffonApplicationUtils.isJdk17()) {
            value = (Float)GriffonClassUtils.invokeInstanceMethod((Object)window, (String)"getOpacity");
        } else if (GriffonApplicationUtils.isJdk16()) {
            Class awtUtilities = SwingUtils.loadClass("com.sun.awt.AWTUtilities");
            value = (Float)GriffonClassUtils.invokeStaticMethod((Class)awtUtilities, (String)"getWindowOpacity", (Object)window);
        }
        return value.floatValue();
    }

    public static void setWindowOpacity(Window window, float opacity) {
        if (GriffonApplicationUtils.isJdk17()) {
            GriffonClassUtils.invokeInstanceMethod((Object)window, (String)"setOpacity", (Object)Float.valueOf(opacity));
        } else if (GriffonApplicationUtils.isJdk16()) {
            Class awtUtilities = SwingUtils.loadClass("com.sun.awt.AWTUtilities");
            GriffonClassUtils.invokeStaticMethod((Class)awtUtilities, (String)"setWindowOpacity", (Object[])new Object[]{window, Float.valueOf(opacity)});
        }
    }

    public static Component findComponentByName(String name, Container root) {
        if (root == null || GriffonNameUtils.isBlank((String)name) || name.equals(root.getName())) {
            return root;
        }
        for (Component comp : root.getComponents()) {
            Component found;
            if (name.equals(comp.getName())) {
                return comp;
            }
            if (!(comp instanceof Container) || (found = SwingUtils.findComponentByName(name, (Container)comp)) == null) continue;
            return found;
        }
        return null;
    }

    public static Image takeSnapshot(Component component) {
        return SwingUtils.takeSnapshot(component, false);
    }

    public static Image takeSnapshot(Component component, boolean usePrint) {
        BufferedImage image = null;
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = genv.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        image = gc.getColorModel().hasAlpha() ? gc.createCompatibleImage((int)component.getSize().getWidth(), (int)component.getSize().getHeight()) : new BufferedImage((int)component.getSize().getWidth(), (int)component.getSize().getHeight(), 2);
        Graphics g = image.getGraphics();
        if (usePrint) {
            component.print(g);
        } else {
            component.paint(g);
        }
        g.dispose();
        return image;
    }

    private static Class loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

