/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing;

import griffon.application.StandaloneGriffonApplication;
import griffon.core.GriffonApplication;
import griffon.core.UIThreadManager;
import griffon.swing.ConfigurableWindowDisplayHandler;
import griffon.swing.SwingGriffonApplication;
import griffon.swing.SwingUIThreadHandler;
import griffon.swing.SwingUtils;
import griffon.swing.WindowDisplayHandler;
import griffon.swing.WindowManager;
import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.griffon.runtime.core.AbstractGriffonApplication;

public abstract class AbstractSwingGriffonApplication
extends AbstractGriffonApplication
implements SwingGriffonApplication,
StandaloneGriffonApplication {
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();
    private static final Class[] CTOR_ARGS = new Class[]{String[].class};

    public AbstractSwingGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractSwingGriffonApplication(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
        UIThreadManager.getInstance().setUIThreadHandler(this.getUIThreadHandler());
        this.addShutdownHandler(this.windowManager);
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    protected UIThreadHandler getUIThreadHandler() {
        return new SwingUIThreadHandler();
    }

    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    public void bootstrap() {
        this.initialize();
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        this.windowManager.show(this.windowManager.getStartingWindow());
        this.callReady();
    }

    public boolean shutdown() {
        if (super.shutdown()) {
            this.exit();
        }
        return false;
    }

    public void exit() {
        System.exit(0);
    }

    public Object createApplicationContainer() {
        Window window = SwingUtils.createApplicationFrame(this);
        return window;
    }

    protected void callReady() {
        final boolean[] empty = new boolean[]{false};
        while (true) {
            UIThreadManager.getInstance().executeSync(new Runnable(){

                public void run() {
                    empty[0] = Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent() == null;
                }
            });
            if (empty[0]) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.ready();
    }

    public static GriffonApplication run(Class applicationClass, String[] args) {
        GriffonExceptionHandler.registerExceptionHandler();
        StandaloneGriffonApplication app = null;
        try {
            app = (StandaloneGriffonApplication)applicationClass.getDeclaredConstructor(CTOR_ARGS).newInstance(new Object[]{args});
            app.bootstrap();
            app.realize();
            app.show();
        }
        catch (InstantiationException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (IllegalAccessException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (InvocationTargetException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (NoSuchMethodException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        return app;
    }
}

