/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import groovy.swing.factory.ComponentFactory;
import groovy.swing.factory.LayoutFactory;
import groovy.swing.factory.ScrollPaneFactory;
import groovy.swing.factory.TableFactory;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import java.awt.LayoutManager;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import org.codehaus.griffon.runtime.builder.DefaultCompositeBuilderCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingCompositeBuilderCustomizer
extends DefaultCompositeBuilderCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(SwingCompositeBuilderCustomizer.class);

    public void registerBeanFactory(FactoryBuilderSupport builder, String name, String groupName, Class<?> beanClass) {
        if (LayoutManager.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using LayoutFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new LayoutFactory(beanClass));
        } else if (JScrollPane.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using ScrollPaneFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new ScrollPaneFactory(beanClass));
        } else if (JTable.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using TableFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new TableFactory(beanClass));
        } else if (JComponent.class.isAssignableFrom(beanClass) || JApplet.class.isAssignableFrom(beanClass) || JDialog.class.isAssignableFrom(beanClass) || JFrame.class.isAssignableFrom(beanClass) || JWindow.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using ComponentFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new ComponentFactory(beanClass));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using default factory");
            }
            builder.registerBeanFactory(name, groupName, beanClass);
        }
    }
}

