/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.awt.Polygon;
import java.util.List;

public class PolygonPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Polygon p = (Polygon)this.getValue();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < p.npoints; ++i) {
            if (i != 0) {
                b.append(" , ");
            }
            b.append(p.xpoints[i]).append(", ").append(p.ypoints[i]);
        }
        return b.toString();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Polygon) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Polygon.class);
        }
    }

    private void handleAsString(String str) {
        String[] parts = str.split(",");
        if (parts.length == 0 || parts.length % 2 == 1) {
            throw this.illegalValue(str, Polygon.class);
        }
        int npoints = parts.length / 2;
        int[] xpoints = new int[npoints];
        int[] ypoints = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            xpoints[i] = this.parse(parts[2 * i]);
            ypoints[i] = this.parse(parts[2 * i + 1]);
        }
        super.setValueInternal((Object)new Polygon(xpoints, ypoints, npoints));
    }

    private void handleAsList(List list) {
        if (list.isEmpty() || list.size() % 2 == 1) {
            throw this.illegalValue(list, Polygon.class);
        }
        int npoints = list.size() / 2;
        int[] xpoints = new int[npoints];
        int[] ypoints = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            xpoints[i] = this.parseValue(list.get(2 * i));
            ypoints[i] = this.parseValue(list.get(2 * i + 1));
        }
        super.setValueInternal((Object)new Polygon(xpoints, ypoints, npoints));
    }

    private int parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Polygon.class);
    }

    private int parse(String val) {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Polygon.class, e);
        }
    }

    private int parse(Number val) {
        return val.intValue();
    }
}

