/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.swing.editors.ColorPropertyEditor;
import java.awt.Color;
import java.awt.GradientPaint;
import java.util.List;
import java.util.Map;

public class GradientPaintPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        GradientPaint p = (GradientPaint)this.getValue();
        return p.getPoint1().getX() + ", " + p.getPoint1().getY() + ", " + ColorPropertyEditor.format(p.getColor1()) + ", " + p.getPoint2().getX() + ", " + p.getPoint2().getY() + ", " + ColorPropertyEditor.format(p.getColor2()) + ", " + p.isCyclic();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof GradientPaint) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, GradientPaint.class);
        }
    }

    private void handleAsString(String str) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        Color c1 = Color.WHITE;
        Color c2 = Color.BLACK;
        boolean cyclic = false;
        if (str.contains("|")) {
            String[] parts = str.split("\\|");
            switch (parts.length) {
                case 4: {
                    cyclic = this.parseBoolean(parts[3]);
                }
                case 3: {
                    ColorPropertyEditor colorEditor = new ColorPropertyEditor();
                    String[] p1 = parts[0].split(",");
                    if (p1.length != 2) {
                        throw this.illegalValue(str, GradientPaint.class);
                    }
                    x1 = this.parseValue(p1[0]);
                    y1 = this.parseValue(p1[1]);
                    String[] p2 = parts[1].split(",");
                    if (p2.length != 2) {
                        throw this.illegalValue(str, GradientPaint.class);
                    }
                    x2 = this.parseValue(p2[0]);
                    y2 = this.parseValue(p2[1]);
                    String[] colors = parts[2].split(",");
                    try {
                        colorEditor.setAsText(colors[0]);
                        c1 = (Color)colorEditor.getValue();
                    }
                    catch (Exception e) {
                        throw this.illegalValue(colors[0], GradientPaint.class);
                    }
                    try {
                        colorEditor.setAsText(colors[1]);
                        c2 = (Color)colorEditor.getValue();
                    }
                    catch (Exception e) {
                        throw this.illegalValue(colors[1], GradientPaint.class);
                    }
                    super.setValueInternal((Object)new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic));
                    break;
                }
                default: {
                    throw this.illegalValue(str, GradientPaint.class);
                }
            }
        } else {
            String[] parts = str.split(",");
            switch (parts.length) {
                case 7: {
                    cyclic = this.parseBoolean(parts[6]);
                }
                case 6: {
                    ColorPropertyEditor colorEditor = new ColorPropertyEditor();
                    x1 = this.parseValue(parts[0]);
                    y1 = this.parseValue(parts[1]);
                    x2 = this.parseValue(parts[3]);
                    y2 = this.parseValue(parts[4]);
                    try {
                        colorEditor.setAsText(parts[2]);
                        c1 = (Color)colorEditor.getValue();
                    }
                    catch (Exception e) {
                        throw this.illegalValue(parts[2], GradientPaint.class);
                    }
                    try {
                        colorEditor.setAsText(parts[5]);
                        c2 = (Color)colorEditor.getValue();
                    }
                    catch (Exception e) {
                        throw this.illegalValue(parts[5], GradientPaint.class);
                    }
                    super.setValueInternal((Object)new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic));
                    break;
                }
                default: {
                    throw this.illegalValue(str, GradientPaint.class);
                }
            }
        }
    }

    private void handleAsList(List list) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        Color c1 = Color.WHITE;
        Color c2 = Color.BLACK;
        boolean cyclic = false;
        switch (list.size()) {
            case 7: {
                cyclic = this.parseBoolean(String.valueOf(list.get(6)));
            }
            case 6: {
                ColorPropertyEditor colorEditor = new ColorPropertyEditor();
                x1 = this.parseValue(list.get(0));
                y1 = this.parseValue(list.get(1));
                x2 = this.parseValue(list.get(3));
                y2 = this.parseValue(list.get(4));
                try {
                    colorEditor.setValueInternal(list.get(2));
                    c1 = (Color)colorEditor.getValue();
                }
                catch (Exception e) {
                    throw this.illegalValue(list.get(2), GradientPaint.class);
                }
                try {
                    colorEditor.setValueInternal(list.get(5));
                    c2 = (Color)colorEditor.getValue();
                }
                catch (Exception e) {
                    throw this.illegalValue(list.get(5), GradientPaint.class);
                }
                super.setValueInternal((Object)new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic));
                break;
            }
            default: {
                throw this.illegalValue(list, GradientPaint.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        float x1 = ((Float)this.getMapValue(map, "x1", Float.valueOf(0.0f))).floatValue();
        float y1 = ((Float)this.getMapValue(map, "y1", Float.valueOf(0.0f))).floatValue();
        float x2 = ((Float)this.getMapValue(map, "x2", Float.valueOf(0.0f))).floatValue();
        float y2 = ((Float)this.getMapValue(map, "y2", Float.valueOf(0.0f))).floatValue();
        Color c1 = Color.WHITE;
        Color c2 = Color.BLACK;
        boolean cyclic = false;
        ColorPropertyEditor colorEditor = new ColorPropertyEditor();
        Object colorValue = map.get("c1");
        try {
            if (null != colorValue) {
                colorEditor.setValueInternal(colorValue);
                c1 = (Color)colorEditor.getValue();
            } else {
                c1 = Color.WHITE;
            }
        }
        catch (Exception e) {
            throw this.illegalValue(colorValue, GradientPaint.class);
        }
        colorValue = map.get("c2");
        try {
            if (null != colorValue) {
                colorEditor.setValueInternal(colorValue);
                c2 = (Color)colorEditor.getValue();
            } else {
                c2 = Color.BLACK;
            }
        }
        catch (Exception e) {
            throw this.illegalValue(colorValue, GradientPaint.class);
        }
        Object cyclicValue = map.get("cyclic");
        if (null != cyclicValue) {
            cyclic = this.parseBoolean(String.valueOf(cyclicValue));
        }
        super.setValueInternal((Object)new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic));
    }

    private float parse(String val) {
        try {
            return Float.parseFloat(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, GradientPaint.class, e);
        }
    }

    private boolean parseBoolean(String val) {
        try {
            return Boolean.parseBoolean(val.trim());
        }
        catch (Exception e) {
            throw this.illegalValue(val, GradientPaint.class, e);
        }
    }

    private float parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, GradientPaint.class);
    }

    private float parse(Number val) {
        return val.floatValue();
    }

    private Object getMapValue(Map map, String key, Object defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return Float.valueOf(this.parse(String.valueOf(val)));
        }
        if (val instanceof Number) {
            return Float.valueOf(this.parse((Number)val));
        }
        throw this.illegalValue(map, GradientPaint.class);
    }
}

