/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.core.resources.formatters.Formatter;
import griffon.core.resources.formatters.ParseException;
import griffon.swing.formatters.ColorFormatter;
import griffon.util.GriffonNameUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ColorPropertyEditor
extends AbstractPropertyEditor {
    public static String format(Color color) {
        return ColorFormatter.LONG.format(color);
    }

    public String getAsText() {
        return GriffonNameUtils.isBlank((String)this.getFormat()) ? ColorPropertyEditor.format((Color)this.getValueInternal()) : this.getFormattedValue();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value).trim());
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Color) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Color.class);
        }
    }

    protected Formatter resolveFormatter() {
        return !StringUtils.isBlank((String)this.getFormat()) ? ColorFormatter.getInstance(this.getFormat()) : null;
    }

    private void handleAsString(String str) {
        try {
            super.setValueInternal((Object)ColorFormatter.parseColor(str));
        }
        catch (ParseException e) {
            throw this.illegalValue(str, Color.class, (Exception)((Object)e));
        }
    }

    private void handleAsList(List list) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.addAll(list);
        switch (list.size()) {
            case 3: {
                values.add(255);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw this.illegalValue(list, Color.class);
            }
        }
        int valuesSize = values.size();
        for (int i = 0; i < valuesSize; ++i) {
            Object val = values.get(i);
            if (val instanceof Number) {
                values.set(i, this.parse((Number)val));
                continue;
            }
            if (!(val instanceof CharSequence)) continue;
            values.set(i, this.parse(String.valueOf(val)));
        }
        super.setValueInternal((Object)new Color((Integer)values.get(0), (Integer)values.get(1), (Integer)values.get(2), (Integer)values.get(3)));
    }

    private void handleAsMap(Map map) {
        int r = this.getMapValue(map, "red", 0);
        int g = this.getMapValue(map, "green", 0);
        int b = this.getMapValue(map, "blue", 0);
        int a = this.getMapValue(map, "alpha", 255);
        super.setValueInternal((Object)new Color(r, g, b, a));
    }

    private int parse(String val) {
        try {
            return Integer.parseInt(String.valueOf(val).trim(), 16) & 0xFF;
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Color.class, e);
        }
    }

    private int parse(Number val) {
        return val.intValue() & 0xFF;
    }

    private int getMapValue(Map map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Color.class);
    }

    private void handleAsNumber(Number value) {
        int c = this.parse(value);
        super.setValueInternal((Object)new Color(c, c, c, 255));
    }
}

