/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing;

import griffon.util.CallableWithArgs;
import griffon.util.CallableWithArgsClosure;
import griffon.util.GriffonNameUtils;
import groovy.util.FactoryBuilderSupport;
import java.util.LinkedHashMap;

public class BindUtils {
    public static BindingBuilder binding() {
        return new BindingBuilder();
    }

    public static class BindingBuilder {
        private Object source;
        private Object target;
        private String sourceProperty;
        private String targetProperty;
        private CallableWithArgs converter;
        private CallableWithArgs validator;
        private boolean mutual;

        public BindingBuilder withSource(Object source) {
            this.source = source;
            return this;
        }

        public BindingBuilder withTarget(Object target) {
            this.target = target;
            return this;
        }

        public BindingBuilder withSourceProperty(String sourceProperty) {
            this.sourceProperty = sourceProperty;
            return this;
        }

        public BindingBuilder withTargetProperty(String targetProperty) {
            this.targetProperty = targetProperty;
            return this;
        }

        public BindingBuilder withConverter(CallableWithArgs converter) {
            this.converter = converter;
            return this;
        }

        public BindingBuilder withValidator(CallableWithArgs validator) {
            this.validator = validator;
            return this;
        }

        public BindingBuilder withMutual(boolean mutual) {
            this.mutual = mutual;
            return this;
        }

        public void make(FactoryBuilderSupport builder) {
            if (builder == null) {
                throw new IllegalArgumentException("Cannot make binding with a null builder!");
            }
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            if (this.source == null) {
                throw new IllegalArgumentException("Unspecified value for: source");
            }
            if (this.target == null) {
                throw new IllegalArgumentException("Unspecified value for: target");
            }
            if (GriffonNameUtils.isBlank((String)this.sourceProperty)) {
                this.sourceProperty = this.targetProperty;
            }
            if (GriffonNameUtils.isBlank((String)this.sourceProperty)) {
                throw new IllegalArgumentException("Unspecified values for: sourceProperty, targetProperty");
            }
            if (GriffonNameUtils.isBlank((String)this.targetProperty)) {
                this.targetProperty = this.sourceProperty;
            }
            attributes.put("source", this.source);
            attributes.put("target", this.target);
            attributes.put("sourceProperty", this.sourceProperty);
            attributes.put("targetProperty", this.targetProperty);
            attributes.put("mutual", this.mutual);
            if (this.converter != null) {
                attributes.put("converter", new CallableWithArgsClosure((Object)builder, this.converter));
            }
            if (this.validator != null) {
                attributes.put("validator", new CallableWithArgsClosure((Object)builder, this.validator));
            }
            builder.invokeMethod("bind", attributes);
        }
    }
}

