/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import griffon.core.GriffonController;
import griffon.core.UIThreadManager;
import griffon.swing.SwingAction;
import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.codehaus.griffon.runtime.core.controller.AbstractGriffonControllerAction;
import org.codehaus.groovy.runtime.InvokerHelper;

public class SwingGriffonControllerAction
extends AbstractGriffonControllerAction {
    private final SwingAction toolkitAction;

    public SwingGriffonControllerAction(GriffonController controller, final String actionName) {
        super(controller, actionName);
        final SwingGriffonControllerAction self = this;
        this.toolkitAction = new SwingAction((Runnable)new RunnableWithArgs(){

            public void run(Object[] args) {
                InvokerHelper.invokeMethod((Object)self.getController(), (String)actionName, (Object)args);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent evt) {
                UIThreadManager.getInstance().executeAsync(new Runnable(){

                    public void run() {
                        String largeIcon;
                        if ("name".equals(evt.getPropertyName())) {
                            SwingGriffonControllerAction.this.toolkitAction.putValue("Name", evt.getNewValue());
                        } else if ("shortDescription".equals(evt.getPropertyName())) {
                            SwingGriffonControllerAction.this.toolkitAction.putValue("ShortDescription", evt.getNewValue());
                        } else if ("longDescription".equals(evt.getPropertyName())) {
                            SwingGriffonControllerAction.this.toolkitAction.putValue("LongDescription", evt.getNewValue());
                        } else if ("enabled".equals(evt.getPropertyName())) {
                            SwingGriffonControllerAction.this.toolkitAction.setEnabled((Boolean)evt.getNewValue());
                        } else if ("selected".equals(evt.getPropertyName())) {
                            SwingGriffonControllerAction.this.toolkitAction.putValue("SwingSelectedKey", evt.getNewValue());
                        } else if ("mnemonic".equals(evt.getPropertyName())) {
                            String mnemonic = (String)evt.getNewValue();
                            if (!GriffonNameUtils.isBlank((String)mnemonic)) {
                                SwingGriffonControllerAction.this.toolkitAction.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
                            }
                        } else if ("accelerator".equals(evt.getPropertyName())) {
                            String accelerator = (String)evt.getNewValue();
                            if (!GriffonNameUtils.isBlank((String)accelerator)) {
                                SwingGriffonControllerAction.this.toolkitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accelerator));
                            }
                        } else if ("smallIcon".equals(evt.getPropertyName())) {
                            String smallIcon = (String)evt.getNewValue();
                            if (!GriffonNameUtils.isBlank((String)smallIcon)) {
                                SwingGriffonControllerAction.this.toolkitAction.putValue("SmallIcon", new ImageIcon(smallIcon));
                            }
                        } else if ("largeIcon".equals(evt.getPropertyName()) && !GriffonNameUtils.isBlank((String)(largeIcon = (String)evt.getNewValue()))) {
                            SwingGriffonControllerAction.this.toolkitAction.putValue("SwingLargeIconKey", new ImageIcon(largeIcon));
                        }
                    }
                });
            }
        });
    }

    public Object getToolkitAction() {
        return this.toolkitAction;
    }

    protected void doExecute(Object ... args) {
        ActionEvent event = null;
        if (args != null && args.length == 1 && args[0] instanceof ActionEvent) {
            event = (ActionEvent)args[0];
        }
        this.toolkitAction.actionPerformed(event);
    }
}

