/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String value) throws IllegalArgumentException {
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URL) {
            this.handleAsURL((URL)value);
        } else if (value instanceof URI) {
            this.handleAsURI((URI)value);
        } else if (value instanceof InputStream) {
            this.handleAsInputStream((InputStream)value);
        } else if (value instanceof ImageInputStream) {
            this.handleAsImageInputStream((ImageInputStream)value);
        } else if (value instanceof byte[]) {
            this.handleAsByteArray((byte[])value);
        } else if (value instanceof Image) {
            this.handleAsImage((Image)value);
        } else if (value instanceof Icon) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, Image.class);
        }
    }

    private void handleAsString(String str) {
        this.handleAsURL(((Object)((Object)this)).getClass().getClassLoader().getResource(str));
    }

    private void handleAsFile(File file) {
        try {
            this.handleAsImage(ImageIO.read(file));
        }
        catch (IOException e) {
            throw this.illegalValue(file, URL.class);
        }
    }

    private void handleAsURL(URL url) {
        try {
            this.handleAsImage(ImageIO.read(url));
        }
        catch (IOException e) {
            throw this.illegalValue(url, URL.class);
        }
    }

    private void handleAsURI(URI uri) {
        try {
            this.handleAsURL(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw this.illegalValue(uri, URL.class);
        }
    }

    private void handleAsInputStream(InputStream stream) {
        try {
            this.handleAsImage(ImageIO.read(stream));
        }
        catch (IOException e) {
            throw this.illegalValue(stream, URL.class);
        }
    }

    private void handleAsImageInputStream(ImageInputStream stream) {
        try {
            this.handleAsImage(ImageIO.read(stream));
        }
        catch (IOException e) {
            throw this.illegalValue(stream, URL.class);
        }
    }

    private void handleAsByteArray(byte[] bytes) {
        super.setValue((Object)new ImageIcon(bytes));
    }

    private void handleAsImage(Image img) {
        super.setValue((Object)new ImageIcon(img));
    }
}

