/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import griffon.swing.editors.ColorPropertyEditor;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.util.List;
import java.util.Map;

public class GradientPaintPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof GradientPaint) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, GradientPaint.class);
        }
    }

    private void handleAsString(String str) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        Color c1 = Color.WHITE;
        Color c2 = Color.BLACK;
        boolean cyclic = false;
        String[] parts = str.split(",");
        switch (parts.length) {
            case 7: {
                cyclic = this.parseBoolean(parts[6]);
            }
            case 6: {
                ColorPropertyEditor colorEditor = new ColorPropertyEditor();
                x1 = this.parseValue(parts[0]);
                y1 = this.parseValue(parts[1]);
                x2 = this.parseValue(parts[3]);
                y2 = this.parseValue(parts[4]);
                try {
                    colorEditor.setAsText(parts[2]);
                    c1 = (Color)colorEditor.getValue();
                }
                catch (Exception e) {
                    throw this.illegalValue(parts[2], GradientPaint.class);
                }
                try {
                    colorEditor.setAsText(parts[5]);
                    c2 = (Color)colorEditor.getValue();
                }
                catch (Exception e) {
                    throw this.illegalValue(parts[5], GradientPaint.class);
                }
                super.setValue((Object)new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic));
                break;
            }
            default: {
                throw this.illegalValue(str, Insets.class);
            }
        }
    }

    private void handleAsList(List list) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        Color c1 = Color.WHITE;
        Color c2 = Color.BLACK;
        boolean cyclic = false;
        switch (list.size()) {
            case 7: {
                cyclic = this.parseBoolean(String.valueOf(list.get(6)));
            }
            case 6: {
                ColorPropertyEditor colorEditor = new ColorPropertyEditor();
                x1 = this.parseValue(list.get(0));
                y1 = this.parseValue(list.get(1));
                x2 = this.parseValue(list.get(3));
                y2 = this.parseValue(list.get(4));
                try {
                    colorEditor.setValue(list.get(2));
                    c1 = (Color)colorEditor.getValue();
                }
                catch (Exception e) {
                    throw this.illegalValue(list.get(2), GradientPaint.class);
                }
                try {
                    colorEditor.setValue(list.get(5));
                    c2 = (Color)colorEditor.getValue();
                }
                catch (Exception e) {
                    throw this.illegalValue(list.get(5), GradientPaint.class);
                }
                super.setValue((Object)new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic));
                break;
            }
            default: {
                throw this.illegalValue(list, Insets.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        float x1 = ((Float)this.getMapValue(map, "x1", 0)).floatValue();
        float y1 = ((Float)this.getMapValue(map, "y1", 0)).floatValue();
        float x2 = ((Float)this.getMapValue(map, "x2", 0)).floatValue();
        float y2 = ((Float)this.getMapValue(map, "y2", 0)).floatValue();
        Color c1 = Color.WHITE;
        Color c2 = Color.BLACK;
        boolean cyclic = false;
        ColorPropertyEditor colorEditor = new ColorPropertyEditor();
        Object colorValue = map.get("c1");
        try {
            if (null != colorValue) {
                colorEditor.setValue(colorValue);
                c1 = (Color)colorEditor.getValue();
            } else {
                c1 = Color.WHITE;
            }
        }
        catch (Exception e) {
            throw this.illegalValue(colorValue, GradientPaint.class);
        }
        colorValue = map.get("c1");
        try {
            if (null != colorValue) {
                colorEditor.setValue(colorValue);
                c2 = (Color)colorEditor.getValue();
            } else {
                c2 = Color.BLACK;
            }
        }
        catch (Exception e) {
            throw this.illegalValue(colorValue, GradientPaint.class);
        }
        Object cyclicValue = map.get("cyclic");
        if (null != cyclicValue) {
            cyclic = this.parseBoolean(String.valueOf(cyclicValue));
        }
        super.setValue((Object)new GradientPaint(x1, y1, c1, x2, y2, c2, cyclic));
    }

    private float parse(String val) {
        try {
            return Float.parseFloat(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, GradientPaint.class, e);
        }
    }

    private boolean parseBoolean(String val) {
        try {
            return Boolean.parseBoolean(val);
        }
        catch (Exception e) {
            throw this.illegalValue(val, GradientPaint.class, e);
        }
    }

    private float parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, GradientPaint.class);
    }

    private int parse(Number val) {
        return val.intValue() & 0xFF;
    }

    private Object getMapValue(Map map, String key, Object defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return Float.valueOf(this.parse(String.valueOf(val)));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, GradientPaint.class);
    }
}

