/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;

public class DimensionPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Dimension) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, Dimension.class);
        }
    }

    private void handleAsString(String str) {
        String[] parts = str.split(",");
        switch (parts.length) {
            case 1: {
                int s = this.parseValue(parts[0]);
                super.setValue((Object)new Dimension(s, s));
                break;
            }
            case 2: {
                int w = this.parseValue(parts[0]);
                int h = this.parseValue(parts[1]);
                super.setValue((Object)new Dimension(w, h));
                break;
            }
            default: {
                throw this.illegalValue(str, Dimension.class);
            }
        }
    }

    private void handleAsList(List list) {
        switch (list.size()) {
            case 1: {
                int s = this.parseValue(list.get(0));
                super.setValue((Object)new Dimension(s, s));
                break;
            }
            case 2: {
                int w = this.parseValue(list.get(0));
                int h = this.parseValue(list.get(1));
                super.setValue((Object)new Dimension(w, h));
                break;
            }
            default: {
                throw this.illegalValue(list, Dimension.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        int w = this.getMapValue(map, "width", 0);
        int h = this.getMapValue(map, "height", 0);
        super.setValue((Object)new Dimension(w, h));
    }

    private int parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Dimension.class);
    }

    private int parse(String val) {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Dimension.class, e);
        }
    }

    private int parse(Number val) {
        return val.intValue();
    }

    private int getMapValue(Map map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Dimension.class);
    }

    private void handleAsNumber(Number value) {
        int s = this.parse(value);
        super.setValue((Object)new Dimension(s, s));
    }
}

