/*
 * Copyright 2008-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package griffon.swing;


/**
 * Basic implementation of {@code GriffonApplication} that runs in standalone/webstart mode.
 *
 * @author Danno Ferrin
 * @author Andres Almiray
 * @since 0.1
 */
public class SwingApplication extends AbstractSwingGriffonApplication {
    public SwingApplication() {
        this(AbstractSwingGriffonApplication.EMPTY_ARGS);
    }

    public SwingApplication(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        AbstractSwingGriffonApplication.run(SwingApplication.class, args);
    }
}
