/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.debug;

import griffon.util.GriffonExceptionHandler;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventDispatchThreadHangMonitor
extends EventQueue {
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatchThreadHangMonitor.class);
    private static final EventDispatchThreadHangMonitor INSTANCE = new EventDispatchThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS = 1000L;
    private static int hangCount = 0;
    private boolean haveShownSomeComponent = false;
    private final LinkedList<DispatchInfo> dispatches = new LinkedList();
    private long timeout = 1000L;

    private EventDispatchThreadHangMonitor() {
        this.initTimer();
    }

    private void initTimer() {
        long initialDelayMs = 0L;
        boolean isDaemon = true;
        Timer timer = new Timer("EventDispatchThreadHangMonitor", true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    public static EventDispatchThreadHangMonitor getInstance() {
        return INSTANCE;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout > 1000L ? timeout : 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent event) {
        try {
            this.preDispatchEvent();
            super.dispatchEvent(event);
        }
        finally {
            this.postDispatchEvent();
            if (!this.haveShownSomeComponent && event instanceof WindowEvent && event.getID() == 200) {
                this.haveShownSomeComponent = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void preDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            this.dispatches.addLast(new DispatchInfo(this.timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void postDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            DispatchInfo justFinishedDispatch = this.dispatches.removeLast();
            justFinishedDispatch.dispose();
            Thread currentEventDispatchThread = Thread.currentThread();
            for (DispatchInfo dispatchInfo : this.dispatches) {
                if (dispatchInfo.eventDispatchThread != currentEventDispatchThread) continue;
                dispatchInfo.lastDispatchTimeMillis = System.currentTimeMillis();
            }
        }
    }

    private static void checkForDeadlock() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadBean.findMonitorDeadlockedThreads();
        if (threadIds == null) {
            return;
        }
        if (LOG.isWarnEnabled()) {
            ThreadInfo[] threadInfos;
            StringBuilder b = new StringBuilder("Deadlock detected involving the following threads:");
            for (ThreadInfo info : threadInfos = threadBean.getThreadInfo(threadIds, Integer.MAX_VALUE)) {
                b.append("Thread #" + info.getThreadId() + " " + info.getThreadName() + " (" + (Object)((Object)info.getThreadState()) + ") waiting on " + info.getLockName() + " held by " + info.getLockOwnerName() + EventDispatchThreadHangMonitor.stackTraceToString(GriffonExceptionHandler.sanitize((StackTraceElement[])info.getStackTrace())));
            }
            LOG.warn(b.toString());
        }
    }

    private static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder result = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace) {
            String indentation = "    ";
            result.append("\n" + indentation + stackTraceElement);
        }
        return result.toString();
    }

    private static synchronized int getNewHangNumber() {
        return ++hangCount;
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = EventDispatchThreadHangMonitor.this.dispatches;
            synchronized (linkedList) {
                if (EventDispatchThreadHangMonitor.this.dispatches.isEmpty() || !EventDispatchThreadHangMonitor.this.haveShownSomeComponent) {
                    return;
                }
                ((DispatchInfo)EventDispatchThreadHangMonitor.this.dispatches.getLast()).checkForHang();
            }
        }
    }

    private static class DispatchInfo {
        private StackTraceElement[] lastReportedStack;
        private int hangNumber;
        private final Thread eventDispatchThread = Thread.currentThread();
        private long lastDispatchTimeMillis = System.currentTimeMillis();
        private final long timeout;

        public DispatchInfo(long timeout) {
            this.timeout = timeout;
        }

        public void checkForHang() {
            if (this.timeSoFar() > this.timeout) {
                this.examineHang();
            }
        }

        private static boolean stackTraceElementIs(StackTraceElement e, String className, String methodName, boolean isNative) {
            return e.getClassName().equals(className) && e.getMethodName().equals(methodName) && e.isNativeMethod() == isNative;
        }

        private boolean isWaitingForNextEvent(StackTraceElement[] currentStack) {
            return DispatchInfo.stackTraceElementIs(currentStack[0], "java.lang.Object", "wait", true) && DispatchInfo.stackTraceElementIs(currentStack[1], "java.lang.Object", "wait", false) && DispatchInfo.stackTraceElementIs(currentStack[2], "java.awt.EventQueue", "getNextEvent", false);
        }

        private void examineHang() {
            StackTraceElement[] currentStack = GriffonExceptionHandler.sanitize((StackTraceElement[])this.eventDispatchThread.getStackTrace());
            if (this.isWaitingForNextEvent(currentStack)) {
                return;
            }
            if (DispatchInfo.stacksEqual(this.lastReportedStack, currentStack)) {
                return;
            }
            this.hangNumber = EventDispatchThreadHangMonitor.getNewHangNumber();
            String stackTrace = EventDispatchThreadHangMonitor.stackTraceToString(currentStack);
            this.lastReportedStack = currentStack;
            if (LOG.isWarnEnabled()) {
                LOG.warn("(hang #" + this.hangNumber + ") event dispatch thread stuck processing event for " + this.timeSoFar() + " ms:" + stackTrace);
            }
            EventDispatchThreadHangMonitor.checkForDeadlock();
        }

        private static boolean stacksEqual(StackTraceElement[] a, StackTraceElement[] b) {
            if (a == null) {
                return false;
            }
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return true;
        }

        private long timeSoFar() {
            return System.currentTimeMillis() - this.lastDispatchTimeMillis;
        }

        public void dispose() {
            if (this.lastReportedStack != null && LOG.isWarnEnabled()) {
                LOG.warn("(hang #" + this.hangNumber + ") event dispatch thread unstuck after " + this.timeSoFar() + " ms.");
            }
        }
    }
}

