/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing;

import griffon.core.UIThreadManager;
import griffon.swing.AbstractGriffonApplet;
import griffon.swing.ConfigurableWindowDisplayHandler;
import griffon.swing.SwingGriffonApplication;
import griffon.swing.SwingUIThreadHandler;
import griffon.swing.SwingUtils;
import griffon.swing.WindowDisplayHandler;
import griffon.swing.WindowManager;
import griffon.util.UIThreadHandler;
import java.awt.Window;

public class SwingApplet
extends AbstractGriffonApplet
implements SwingGriffonApplication {
    private boolean appletContainerDispensed = false;
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();

    public SwingApplet() {
        this(EMPTY_ARGS);
    }

    public SwingApplet(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
        UIThreadManager.getInstance().setUIThreadHandler(this.getUIThreadHandler());
        this.addShutdownHandler(this.windowManager);
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    protected UIThreadHandler getUIThreadHandler() {
        return new SwingUIThreadHandler();
    }

    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    public Object createApplicationContainer() {
        if (this.appletContainerDispensed) {
            Window window = SwingUtils.createApplicationFrame(this);
            this.windowManager.attach(window);
            return window;
        }
        this.appletContainerDispensed = true;
        return this;
    }
}

