/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing;

import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import griffon.util.RunnableWithArgsClosure;
import groovy.lang.Closure;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class SwingAction
extends AbstractAction {
    private final Closure closure;

    public SwingAction(Closure closure) {
        this.closure = closure;
    }

    public final void actionPerformed(ActionEvent evt) {
        this.closure.call((Object)evt);
    }

    public static ActionBuilder action() {
        return new ActionBuilder();
    }

    public static ActionBuilder action(Action action) {
        return new ActionBuilder(action);
    }

    public static ActionBuilder action(String name) {
        return new ActionBuilder().withName(name);
    }

    public static class ActionBuilder {
        private String name;
        private int mnemonic;
        private KeyStroke accelerator;
        private String shortDescription;
        private String longDescription;
        private String command;
        private Icon smallIcon;
        private Icon largeIcon;
        private Closure closure;
        private boolean enabled = true;
        private Action action;
        private boolean mnemonicSet = false;
        private boolean enabledSet = false;

        public ActionBuilder() {
            this(null);
        }

        public ActionBuilder(Action action) {
            this.action = action;
        }

        public ActionBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ActionBuilder withShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public ActionBuilder withLongDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public ActionBuilder withCommand(String command) {
            this.command = command;
            return this;
        }

        public ActionBuilder withMnemonic(String mnemonic) {
            this.mnemonic = KeyStroke.getKeyStroke(mnemonic).getKeyCode();
            this.mnemonicSet = true;
            return this;
        }

        public ActionBuilder withMnemonic(int mnemonic) {
            this.mnemonic = mnemonic;
            this.mnemonicSet = true;
            return this;
        }

        public ActionBuilder withAccelerator(String accelerator) {
            this.accelerator = KeyStroke.getKeyStroke(accelerator);
            return this;
        }

        public ActionBuilder withAccelerator(KeyStroke accelerator) {
            this.accelerator = accelerator;
            return this;
        }

        public ActionBuilder withSmallIcon(Icon smallIcon) {
            this.smallIcon = smallIcon;
            return this;
        }

        public ActionBuilder withLargeIcon(Icon largeIcon) {
            this.largeIcon = largeIcon;
            return this;
        }

        public ActionBuilder withClosure(Closure closure) {
            this.closure = closure;
            return this;
        }

        public ActionBuilder withRunnable(RunnableWithArgs runnable) {
            if (runnable != null) {
                this.closure = new RunnableWithArgsClosure(runnable);
            }
            return this;
        }

        public ActionBuilder withEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledSet = true;
            return this;
        }

        public Action build() {
            if (this.closure == null && this.action == null) {
                throw new IllegalArgumentException("Either closure: or action: must have a value.");
            }
            if (this.action == null) {
                this.action = new SwingAction(this.closure);
            }
            if (!GriffonNameUtils.isBlank((String)this.command)) {
                this.action.putValue("ActionCommandKey", this.command);
            }
            if (!GriffonNameUtils.isBlank((String)this.name)) {
                this.action.putValue("Name", this.name);
            }
            if (this.mnemonicSet) {
                this.action.putValue("MnemonicKey", this.mnemonic);
            }
            if (this.accelerator != null) {
                this.action.putValue("AcceleratorKey", this.accelerator);
            }
            if (this.largeIcon != null) {
                this.action.putValue("SwingLargeIconKey", this.largeIcon);
            }
            if (this.smallIcon != null) {
                this.action.putValue("SmallIcon", this.smallIcon);
            }
            if (!GriffonNameUtils.isBlank((String)this.longDescription)) {
                this.action.putValue("LongDescription", this.longDescription);
            }
            if (!GriffonNameUtils.isBlank((String)this.shortDescription)) {
                this.action.putValue("ShortDescription", this.shortDescription);
            }
            if (this.enabledSet) {
                this.action.setEnabled(this.enabled);
            }
            return this.action;
        }
    }
}

