/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.spring;

import grails.spring.BeanBuilder;
import griffon.core.GriffonApplication;
import griffon.util.ApplicationClassLoader;
import griffon.util.CollectionUtils;
import griffon.util.GriffonExceptionHandler;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.griffon.runtime.spring.DefaultRuntimeSpringConfiguration;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GriffonRuntimeConfigurator
implements ApplicationContextAware {
    public static final String SPRING_RESOURCES_XML = "spring/springbeans.xml";
    public static final String SPRING_RESOURCES_CLASS = "springbeans";
    public static final String CLASS_LOADER_BEAN = "classLoader";
    private static final Log LOG = LogFactory.getLog(GriffonRuntimeConfigurator.class);
    private GriffonApplication application;
    private ApplicationContext parent;
    private static volatile BeanBuilder springGroovyResourcesBeanBuilder = null;

    public GriffonRuntimeConfigurator(GriffonApplication application) {
        this(application, null);
    }

    public GriffonRuntimeConfigurator(GriffonApplication application, ApplicationContext parent) {
        this.application = application;
        this.parent = parent;
    }

    public ApplicationContext configure(boolean loadExternalBeans) {
        DefaultRuntimeSpringConfiguration springConfig = new DefaultRuntimeSpringConfiguration(this.parent, ApplicationClassLoader.get());
        return this.configure(springConfig, loadExternalBeans);
    }

    public ApplicationContext configure(DefaultRuntimeSpringConfiguration springConfig) {
        return this.configure(springConfig, true);
    }

    public ApplicationContext configure(DefaultRuntimeSpringConfiguration springConfig, boolean loadExternalBeans) {
        Assert.notNull((Object)this.application);
        springConfig = springConfig != null ? springConfig : new DefaultRuntimeSpringConfiguration(this.parent, ApplicationClassLoader.get());
        this.registerParentBeanFactoryPostProcessors(springConfig);
        LOG.debug((Object)"[RuntimeConfiguration] Processing additional external configurations");
        if (loadExternalBeans) {
            this.doPostResourceConfiguration(this.application, springConfig);
        }
        this.reset();
        ApplicationContext ctx = springConfig.getApplicationContext();
        return ctx;
    }

    private void registerParentBeanFactoryPostProcessors(DefaultRuntimeSpringConfiguration springConfig) {
        if (this.parent != null) {
            Map parentPostProcessors = this.parent.getBeansOfType(BeanFactoryPostProcessor.class);
            for (Object o : parentPostProcessors.values()) {
                BeanFactoryPostProcessor postProcessor = (BeanFactoryPostProcessor)o;
                ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor(postProcessor);
            }
        }
    }

    private void doPostResourceConfiguration(GriffonApplication application, RuntimeSpringConfiguration springConfig) {
        ClassLoader classLoader = ApplicationClassLoader.get();
        String resourceName = SPRING_RESOURCES_XML;
        try {
            ClassPathResource springResources = new ClassPathResource(resourceName);
            if (springResources != null && springResources.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[RuntimeConfiguration] Configuring additional beans from " + springResources.getURL()));
                }
                DefaultListableBeanFactory xmlBf = new DefaultListableBeanFactory();
                new XmlBeanDefinitionReader((BeanDefinitionRegistry)xmlBf).loadBeanDefinitions((Resource)springResources);
                xmlBf.setBeanClassLoader(classLoader);
                String[] beanNames = xmlBf.getBeanDefinitionNames();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[RuntimeConfiguration] Found [" + beanNames.length + "] beans to configure"));
                }
                for (String beanName : beanNames) {
                    String[] aliases;
                    BeanDefinition bd = xmlBf.getBeanDefinition(beanName);
                    String beanClassName = bd.getBeanClassName();
                    Class beanClass = beanClassName == null ? null : ClassUtils.forName((String)beanClassName, (ClassLoader)classLoader);
                    springConfig.addBeanDefinition(beanName, bd);
                    for (String alias : aliases = xmlBf.getAliases(beanName)) {
                        springConfig.addAlias(alias, beanName);
                    }
                    if (beanClass == null || !BeanFactoryPostProcessor.class.isAssignableFrom(beanClass)) continue;
                    ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor((BeanFactoryPostProcessor)xmlBf.getBean(beanName));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[RuntimeConfiguration] " + resourceName + " not found. Skipping configuration."));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("[RuntimeConfiguration] Unable to perform post initialization config: " + resourceName), GriffonExceptionHandler.sanitize((Throwable)ex));
        }
        GriffonRuntimeConfigurator.loadSpringGroovyResources(springConfig, application);
    }

    private static void doLoadSpringGroovyResources(RuntimeSpringConfiguration config, GriffonApplication application, GenericApplicationContext context) {
        GriffonRuntimeConfigurator.loadExternalSpringConfig(config, application);
        if (context != null) {
            springGroovyResourcesBeanBuilder.registerBeans((BeanDefinitionRegistry)context);
        }
    }

    public static void loadExternalSpringConfig(RuntimeSpringConfiguration config, GriffonApplication application) {
        if (springGroovyResourcesBeanBuilder == null) {
            try {
                Class groovySpringResourcesClass = null;
                try {
                    groovySpringResourcesClass = ClassUtils.forName((String)SPRING_RESOURCES_CLASS, (ClassLoader)ApplicationClassLoader.get());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (groovySpringResourcesClass != null) {
                    GriffonRuntimeConfigurator.loadPluginGroovyResources(config, application);
                    springGroovyResourcesBeanBuilder = new BeanBuilder(null, config, ApplicationClassLoader.get());
                    GriffonRuntimeConfigurator.reloadSpringResourcesConfig(application, springGroovyResourcesBeanBuilder, groovySpringResourcesClass);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"[RuntimeConfiguration] Unable to load beans from resources.groovy", GriffonExceptionHandler.sanitize((Throwable)ex));
            }
        } else if (!springGroovyResourcesBeanBuilder.getSpringConfig().equals(config)) {
            springGroovyResourcesBeanBuilder.registerBeans(config);
        }
    }

    public static BeanBuilder reloadSpringResourcesConfig(GriffonApplication application, BeanBuilder beanBuilder, Class<?> groovySpringResourcesClass) throws InstantiationException, IllegalAccessException {
        beanBuilder.setBinding(new Binding(CollectionUtils.newMap((Object[])new Object[]{"application", application})));
        Script script = (Script)groovySpringResourcesClass.newInstance();
        script.run();
        Object beans = script.getProperty("beans");
        beanBuilder.beans((Closure)beans);
        return beanBuilder;
    }

    private static BeanBuilder loadPluginGroovyResources(RuntimeSpringConfiguration config, GriffonApplication application) {
        ClassLoader classLoader = ApplicationClassLoader.get();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        GroovyClassLoader gcl = new GroovyClassLoader(classLoader);
        BeanBuilder bb = new BeanBuilder(null, config, classLoader);
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:/META-INF/spring/springbeans.groovy")) {
                try {
                    Class scriptClass = gcl.parseClass(new GroovyCodeSource(resource.getURL()));
                    GriffonRuntimeConfigurator.reloadSpringResourcesConfig(application, bb, scriptClass);
                }
                catch (Exception ex) {
                    LOG.error((Object)("[RuntimeConfiguration] Unable to load beans from " + resource), GriffonExceptionHandler.sanitize((Throwable)ex));
                }
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"[RuntimeConfiguration] Unable to load beans from plugin resources", GriffonExceptionHandler.sanitize((Throwable)ioe));
        }
        return bb;
    }

    public static void loadSpringGroovyResources(RuntimeSpringConfiguration config, GriffonApplication application) {
        GriffonRuntimeConfigurator.loadExternalSpringConfig(config, application);
    }

    public static void loadSpringGroovyResourcesIntoContext(RuntimeSpringConfiguration config, GriffonApplication application, GenericApplicationContext context) {
        GriffonRuntimeConfigurator.loadExternalSpringConfig(config, application);
        GriffonRuntimeConfigurator.doLoadSpringGroovyResources(config, application, context);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.parent = applicationContext;
    }

    public void reset() {
        springGroovyResourcesBeanBuilder = null;
    }
}

