/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.spring;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.griffon.runtime.spring.GriffonApplicationContext;
import org.codehaus.groovy.grails.commons.spring.BeanConfiguration;
import org.codehaus.groovy.grails.commons.spring.DefaultBeanConfiguration;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;

public class DefaultRuntimeSpringConfiguration
implements RuntimeSpringConfiguration {
    private static final Log LOG = LogFactory.getLog(DefaultRuntimeSpringConfiguration.class);
    protected GenericApplicationContext context;
    private Map<String, BeanConfiguration> beanConfigs = new HashMap<String, BeanConfiguration>();
    private Map<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
    private List<String> beanNames = new ArrayList<String>();
    protected ApplicationContext parent;
    protected ClassLoader classLoader;
    protected Map<String, List> aliases = new HashMap<String, List>();
    protected ListableBeanFactory beanFactory;

    public DefaultRuntimeSpringConfiguration() {
    }

    protected GenericApplicationContext createApplicationContext(ApplicationContext parent) {
        if (parent != null && this.beanFactory != null) {
            if (this.beanFactory instanceof DefaultListableBeanFactory) {
                return new GriffonApplicationContext((DefaultListableBeanFactory)this.beanFactory, parent);
            }
            throw new IllegalArgumentException("ListableBeanFactory set must be a subclass of DefaultListableBeanFactory");
        }
        if (this.beanFactory != null) {
            if (this.beanFactory instanceof DefaultListableBeanFactory) {
                return new GriffonApplicationContext((DefaultListableBeanFactory)this.beanFactory);
            }
            throw new IllegalArgumentException("ListableBeanFactory set must be a subclass of DefaultListableBeanFactory");
        }
        if (parent != null) {
            return new GriffonApplicationContext(parent);
        }
        return new GriffonApplicationContext();
    }

    public DefaultRuntimeSpringConfiguration(ApplicationContext parent) {
        this(parent, null);
    }

    public DefaultRuntimeSpringConfiguration(ApplicationContext parent, ClassLoader cl) {
        this.parent = parent;
        this.classLoader = cl;
    }

    private void trySettingClassLoaderOnContextIfFoundInParent(ApplicationContext parent) {
        Object classLoader;
        if (parent.containsBean("classLoader") && (classLoader = parent.getBean("classLoader")) instanceof ClassLoader) {
            ClassLoader cl = (ClassLoader)classLoader;
            this.setClassLoaderOnContext(cl);
        }
    }

    private void setClassLoaderOnContext(ClassLoader cl) {
        this.context.setClassLoader(cl);
        this.context.getBeanFactory().setBeanClassLoader(cl);
    }

    protected void initialiseApplicationContext() {
        if (this.context == null) {
            this.context = this.createApplicationContext(this.parent);
            if (this.parent != null && this.classLoader == null) {
                this.trySettingClassLoaderOnContextIfFoundInParent(this.parent);
            } else if (this.classLoader != null) {
                this.setClassLoaderOnContext(this.classLoader);
            }
            Assert.notNull((Object)this.context);
        }
    }

    public BeanConfiguration addSingletonBean(String name, Class clazz) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz);
        this.registerBeanConfiguration(name, (BeanConfiguration)bc);
        return bc;
    }

    public BeanConfiguration addPrototypeBean(String name, Class clazz) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz, true);
        this.registerBeanConfiguration(name, (BeanConfiguration)bc);
        return bc;
    }

    public ApplicationContext getApplicationContext() {
        this.initialiseApplicationContext();
        this.registerBeansWithContext(this.context);
        this.context.refresh();
        return this.context;
    }

    public ApplicationContext getUnrefreshedApplicationContext() {
        this.initialiseApplicationContext();
        return this.context;
    }

    public BeanConfiguration addSingletonBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name);
        this.registerBeanConfiguration(name, (BeanConfiguration)bc);
        return bc;
    }

    public BeanConfiguration createSingletonBean(Class clazz) {
        return new DefaultBeanConfiguration(clazz);
    }

    public BeanConfiguration addSingletonBean(String name, Class clazz, Collection args) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz, args);
        this.registerBeanConfiguration(name, (BeanConfiguration)bc);
        return bc;
    }

    public BeanConfiguration addPrototypeBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, true);
        this.registerBeanConfiguration(name, (BeanConfiguration)bc);
        return bc;
    }

    private void registerBeanConfiguration(String name, BeanConfiguration bc) {
        this.beanConfigs.put(name, bc);
        this.beanNames.add(name);
    }

    public BeanConfiguration createSingletonBean(Class clazz, Collection constructorArguments) {
        return new DefaultBeanConfiguration(clazz, constructorArguments);
    }

    public BeanConfiguration createPrototypeBean(String name) {
        return new DefaultBeanConfiguration(name, true);
    }

    public BeanConfiguration createSingletonBean(String name) {
        return new DefaultBeanConfiguration(name);
    }

    public void addBeanConfiguration(String beanName, BeanConfiguration beanConfiguration) {
        beanConfiguration.setName(beanName);
        this.registerBeanConfiguration(beanName, beanConfiguration);
    }

    public void addBeanDefinition(String name, BeanDefinition bd) {
        this.beanDefinitions.put(name, bd);
        this.beanNames.add(name);
    }

    public boolean containsBean(String name) {
        return this.beanNames.contains(name);
    }

    public BeanConfiguration getBeanConfig(String name) {
        return this.beanConfigs.get(name);
    }

    public AbstractBeanDefinition createBeanDefinition(String name) {
        if (this.containsBean(name)) {
            if (this.beanDefinitions.containsKey(name)) {
                return (AbstractBeanDefinition)this.beanDefinitions.get(name);
            }
            if (this.beanConfigs.containsKey(name)) {
                return this.beanConfigs.get(name).getBeanDefinition();
            }
        }
        return null;
    }

    public void registerPostProcessor(BeanFactoryPostProcessor processor) {
        this.initialiseApplicationContext();
        this.context.addBeanFactoryPostProcessor(processor);
    }

    public List getBeanNames() {
        return this.beanNames;
    }

    public void registerBeansWithContext(GenericApplicationContext applicationContext) {
        this.registerBeansWithRegistry((BeanDefinitionRegistry)applicationContext);
    }

    public void registerBeansWithRegistry(BeanDefinitionRegistry registry) {
        this.registerUnrefreshedBeansWithRegistry(registry);
        this.registerBeanConfigsWithRegistry(registry);
        this.registerBeanDefinitionsWithRegistry(registry);
    }

    private void registerUnrefreshedBeansWithRegistry(BeanDefinitionRegistry registry) {
        if (this.context != null) {
            for (String beanName : this.context.getBeanDefinitionNames()) {
                registry.registerBeanDefinition(beanName, this.context.getBeanDefinition(beanName));
            }
        }
    }

    private void registerBeanConfigsWithRegistry(BeanDefinitionRegistry registry) {
        Iterator<BeanConfiguration> i$ = this.beanConfigs.values().iterator();
        while (i$.hasNext()) {
            BeanConfiguration o;
            BeanConfiguration bc = o = i$.next();
            String beanName = bc.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[RuntimeConfiguration] Registering bean [" + beanName + "]"));
                if (LOG.isTraceEnabled()) {
                    PropertyValue[] pvs;
                    for (PropertyValue pv : pvs = bc.getBeanDefinition().getPropertyValues().getPropertyValues()) {
                        LOG.trace((Object)("[RuntimeConfiguration] With property [" + pv.getName() + "] set to [" + pv.getValue() + "]"));
                    }
                }
            }
            if (registry.containsBeanDefinition(beanName)) {
                this.removeBeanDefinition(registry, beanName);
            }
            registry.registerBeanDefinition(beanName, (BeanDefinition)bc.getBeanDefinition());
            this.registerBeanAliases(registry, beanName);
        }
    }

    private void registerBeanDefinitionsWithRegistry(BeanDefinitionRegistry registry) {
        for (String key : this.beanDefinitions.keySet()) {
            String beanName;
            BeanDefinition bd = this.beanDefinitions.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[RuntimeConfiguration] Registering bean [" + key + "]"));
                if (LOG.isTraceEnabled()) {
                    PropertyValue[] pvs;
                    for (PropertyValue pv : pvs = bd.getPropertyValues().getPropertyValues()) {
                        LOG.trace((Object)("[RuntimeConfiguration] With property [" + pv.getName() + "] set to [" + pv.getValue() + "]"));
                    }
                }
            }
            if (registry.containsBeanDefinition(beanName = key.toString())) {
                this.removeBeanDefinition(registry, beanName);
            }
            registry.registerBeanDefinition(beanName, bd);
            this.registerBeanAliases(registry, beanName);
        }
    }

    public void registerBeansWithConfig(RuntimeSpringConfiguration targetSpringConfig) {
        if (targetSpringConfig != null) {
            ApplicationContext ctx = targetSpringConfig.getUnrefreshedApplicationContext();
            if (ctx instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)ctx;
                this.registerUnrefreshedBeansWithRegistry(registry);
                this.registerBeansWithRegistry(registry);
            }
            for (Map.Entry<String, BeanConfiguration> beanEntry : this.beanConfigs.entrySet()) {
                targetSpringConfig.addBeanConfiguration(beanEntry.getKey(), beanEntry.getValue());
            }
        }
    }

    private void registerBeanAliases(BeanDefinitionRegistry beanDefinitionRegistry, String beanName) {
        List beanAliases = this.aliases.get(beanName);
        if (beanAliases != null && !beanAliases.isEmpty()) {
            for (Object beanAliase : beanAliases) {
                String alias = (String)beanAliase;
                beanDefinitionRegistry.registerAlias(beanName, alias);
            }
        }
    }

    private void removeBeanDefinition(BeanDefinitionRegistry registry, String beanName) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(registry.getClass());
        if (mc.respondsTo((Object)registry, "removeBeanDefinition").size() > 0) {
            mc.invokeMethod((Object)registry, "removeBeanDefinition", new Object[]{beanName});
        }
    }

    public BeanConfiguration addAbstractBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name);
        bc.setAbstract(true);
        this.registerBeanConfiguration(name, (BeanConfiguration)bc);
        return bc;
    }

    public void addAlias(String alias, String beanName) {
        ArrayList<String> beanAliases = this.aliases.get(beanName);
        if (beanAliases == null) {
            beanAliases = new ArrayList<String>();
            this.aliases.put(beanName, beanAliases);
        }
        beanAliases.add(alias);
    }

    public BeanDefinition getBeanDefinition(String beanName) {
        return this.beanDefinitions.get(beanName);
    }

    public void setBeanFactory(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

