/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.GriffonService;
import griffon.spring.ApplicationContextHolder;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.griffon.runtime.core.AbstractServiceManager;
import org.codehaus.griffon.runtime.core.DefaultGriffonServiceClass;
import org.codehaus.griffon.runtime.core.SpringArtifactHandlerAdapter;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringServiceArtifactHandler
extends SpringArtifactHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SpringServiceArtifactHandler.class);

    public SpringServiceArtifactHandler(GriffonApplication app) {
        super(app, "service", "Service");
        SpringServiceManager serviceManager = new SpringServiceManager(app);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering " + (Object)((Object)serviceManager) + " as ServiceManager.");
        }
        InvokerHelper.setProperty((Object)app, (String)"serviceManager", (Object)((Object)serviceManager));
    }

    protected GriffonClass newGriffonClassInstance(Class clazz) {
        return new DefaultGriffonServiceClass(this.getApp(), clazz);
    }

    @Override
    public void registerArtifacts() {
        this.registerGriffonClasses();
        this.registerInstances(true);
    }

    private class SpringServiceManager
    extends AbstractServiceManager {
        private final Map<String, GriffonService> serviceInstances;

        public SpringServiceManager(GriffonApplication app) {
            super(app);
            this.serviceInstances = new ConcurrentHashMap<String, GriffonService>();
        }

        public Map<String, GriffonService> getServices() {
            return Collections.unmodifiableMap(this.serviceInstances);
        }

        protected GriffonService doFindService(String name) {
            return this.serviceInstances.get(name);
        }

        protected GriffonService doInstantiateService(String name) {
            GriffonService service = (GriffonService)ApplicationContextHolder.getApplicationContext().getBean(name);
            this.serviceInstances.put(name, service);
            return service;
        }
    }
}

