/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.spring;

import grails.spring.BeanBuilder;
import griffon.core.GriffonApplication;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.griffon.runtime.spring.DefaultRuntimeSpringConfiguration;
import org.codehaus.griffon.runtime.spring.GriffonApplicationContext;
import org.codehaus.groovy.grails.commons.spring.RuntimeSpringConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GriffonRuntimeConfigurator
implements ApplicationContextAware {
    public static final String BEAN_ID = "griffonConfigurator";
    public static final String SPRING_RESOURCES_XML = "/spring/springbeans.xml";
    public static final String SPRING_RESOURCES_GROOVY = "/spring/springbeans.groovy";
    public static final String SPRING_RESOURCES_CLASS = "springbeans";
    public static final String MESSAGE_SOURCE_BEAN = "messageSource";
    public static final String EXCEPTION_HANDLER_BEAN = "exceptionHandler";
    public static final String CUSTOM_EDITORS_BEAN = "customEditors";
    public static final String CLASS_EDITOR_BEAN = "classEditor";
    public static final String CLASS_LOADER_BEAN = "classLoader";
    private static final Log LOG = LogFactory.getLog(GriffonRuntimeConfigurator.class);
    private GriffonApplication application;
    private ApplicationContext parent;
    private boolean loadExternalPersistenceConfig;
    private static final String DEVELOPMENT_SPRING_RESOURCES_XML = "file:./griffon-app/conf/spring/springbeans.xml";
    private static volatile BeanBuilder springGroovyResourcesBeanBuilder = null;

    public GriffonRuntimeConfigurator(GriffonApplication application) {
        this(application, null);
    }

    public GriffonRuntimeConfigurator(GriffonApplication application, ApplicationContext parent) {
        this.application = application;
        this.parent = parent;
    }

    public ApplicationContext configure() {
        return this.configure(true);
    }

    public ApplicationContext configure(boolean loadExternalBeans) {
        DefaultRuntimeSpringConfiguration springConfig = new DefaultRuntimeSpringConfiguration(this.parent, this.application.getClass().getClassLoader());
        return this.configure(springConfig, loadExternalBeans);
    }

    public ApplicationContext configure(DefaultRuntimeSpringConfiguration springConfig) {
        return this.configure(springConfig, true);
    }

    public ApplicationContext configure(DefaultRuntimeSpringConfiguration springConfig, boolean loadExternalBeans) {
        Assert.notNull((Object)this.application);
        springConfig = springConfig != null ? springConfig : new DefaultRuntimeSpringConfiguration(this.parent, this.application.getClass().getClassLoader());
        this.registerParentBeanFactoryPostProcessors(springConfig);
        LOG.debug((Object)"[RuntimeConfiguration] Processing additional external configurations");
        if (loadExternalBeans) {
            this.doPostResourceConfiguration(this.application, springConfig);
        }
        this.reset();
        ApplicationContext ctx = springConfig.getApplicationContext();
        return ctx;
    }

    private void registerParentBeanFactoryPostProcessors(DefaultRuntimeSpringConfiguration springConfig) {
        if (this.parent != null) {
            Map parentPostProcessors = this.parent.getBeansOfType(BeanFactoryPostProcessor.class);
            for (Object o : parentPostProcessors.values()) {
                BeanFactoryPostProcessor postProcessor = (BeanFactoryPostProcessor)o;
                ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor(postProcessor);
            }
        }
    }

    public void reconfigure(GriffonApplicationContext current, boolean loadExternalBeans) {
        DefaultRuntimeSpringConfiguration springConfig = this.parent != null ? new DefaultRuntimeSpringConfiguration(this.parent) : new DefaultRuntimeSpringConfiguration();
        List beanNames = springConfig.getBeanNames();
        for (Object beanName : beanNames) {
            String name = (String)beanName;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Re-creating bean definition [" + name + "]"));
            }
            current.registerBeanDefinition(name, (BeanDefinition)springConfig.createBeanDefinition(name));
            current.getBean(name);
        }
        if (loadExternalBeans) {
            this.doPostResourceConfiguration(this.application, springConfig);
        }
        this.reset();
    }

    public ApplicationContext configureDomainOnly() {
        DefaultRuntimeSpringConfiguration springConfig = new DefaultRuntimeSpringConfiguration(this.parent, this.application.getClass().getClassLoader());
        ApplicationContext ctx = springConfig.getApplicationContext();
        return ctx;
    }

    private void doPostResourceConfiguration(GriffonApplication application, RuntimeSpringConfiguration springConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
            Resource springbeans = patternResolver.getResource(SPRING_RESOURCES_XML);
            if (springbeans != null && springbeans.exists()) {
                LOG.debug((Object)("[RuntimeConfiguration] Configuring additional beans from " + springbeans.getURL()));
                XmlBeanFactory xmlBf = new XmlBeanFactory(springbeans);
                xmlBf.setBeanClassLoader(classLoader);
                String[] beanNames = xmlBf.getBeanDefinitionNames();
                LOG.debug((Object)("[RuntimeConfiguration] Found [" + beanNames.length + "] beans to configure"));
                for (String beanName : beanNames) {
                    String[] aliases;
                    BeanDefinition bd = xmlBf.getBeanDefinition(beanName);
                    String beanClassName = bd.getBeanClassName();
                    Class beanClass = beanClassName == null ? null : ClassUtils.forName((String)beanClassName, (ClassLoader)classLoader);
                    springConfig.addBeanDefinition(beanName, bd);
                    for (String alias : aliases = xmlBf.getAliases(beanName)) {
                        springConfig.addAlias(alias, beanName);
                    }
                    if (beanClass == null || !BeanFactoryPostProcessor.class.isAssignableFrom(beanClass)) continue;
                    ((ConfigurableApplicationContext)springConfig.getUnrefreshedApplicationContext()).addBeanFactoryPostProcessor((BeanFactoryPostProcessor)xmlBf.getBean(beanName));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[RuntimeConfiguration] /spring/springbeans.xml not found. Skipping configuration.");
            }
            GriffonRuntimeConfigurator.loadSpringGroovyResources(springConfig, classLoader);
        }
        catch (Exception ex) {
            LOG.warn((Object)"[RuntimeConfiguration] Unable to perform post initialization config: /spring/springbeans.xml", (Throwable)ex);
        }
    }

    private static void doLoadSpringGroovyResources(RuntimeSpringConfiguration config, ClassLoader classLoader, GenericApplicationContext context) {
        GriffonRuntimeConfigurator.loadExternalSpringConfig(config, classLoader);
        if (springGroovyResourcesBeanBuilder != null && context != null) {
            springGroovyResourcesBeanBuilder.registerBeans((BeanDefinitionRegistry)context);
        }
    }

    public static void loadExternalSpringConfig(RuntimeSpringConfiguration config, ClassLoader classLoader) {
        if (springGroovyResourcesBeanBuilder == null) {
            GriffonRuntimeConfigurator.loadPluginGroovyResources(config, classLoader);
            try {
                Class groovySpringResourcesClass = null;
                try {
                    groovySpringResourcesClass = ClassUtils.forName((String)SPRING_RESOURCES_CLASS, (ClassLoader)classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                GriffonRuntimeConfigurator.loadBeansFromScript(config, groovySpringResourcesClass);
            }
            catch (Exception ex) {
                LOG.error((Object)"[RuntimeConfiguration] Unable to load beans from springbeans.groovy", (Throwable)ex);
            }
        } else if (!springGroovyResourcesBeanBuilder.getSpringConfig().equals(config)) {
            springGroovyResourcesBeanBuilder.registerBeans(config);
        }
    }

    private static void loadBeansFromScript(RuntimeSpringConfiguration config, Class scriptClass) throws Exception {
        if (scriptClass == null) {
            return;
        }
        if (springGroovyResourcesBeanBuilder == null) {
            springGroovyResourcesBeanBuilder = new BeanBuilder(null, config, Thread.currentThread().getContextClassLoader());
        }
        Script script = (Script)scriptClass.newInstance();
        script.run();
        Object beans = script.getProperty("beans");
        springGroovyResourcesBeanBuilder.beans((Closure)beans);
    }

    private static void loadPluginGroovyResources(RuntimeSpringConfiguration config, ClassLoader classLoader) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        GroovyClassLoader gcl = new GroovyClassLoader(classLoader);
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:/META-INF/spring/springbeans.groovy")) {
                try {
                    Class scriptClass = gcl.parseClass(new GroovyCodeSource(resource.getURL()));
                    GriffonRuntimeConfigurator.loadBeansFromScript(config, scriptClass);
                }
                catch (Exception ex) {
                    LOG.error((Object)("[RuntimeConfiguration] Unable to load beans from " + resource), (Throwable)ex);
                }
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"[RuntimeConfiguration] Unable to load beans from plugin resources", (Throwable)ioe);
        }
    }

    public static void loadSpringGroovyResources(RuntimeSpringConfiguration config, ClassLoader classLoader) {
        GriffonRuntimeConfigurator.loadExternalSpringConfig(config, classLoader);
    }

    public static void loadSpringGroovyResourcesIntoContext(RuntimeSpringConfiguration config, ClassLoader classLoader, GenericApplicationContext context) {
        GriffonRuntimeConfigurator.loadExternalSpringConfig(config, classLoader);
        GriffonRuntimeConfigurator.doLoadSpringGroovyResources(config, classLoader, context);
    }

    public void setLoadExternalPersistenceConfig(boolean b) {
        this.loadExternalPersistenceConfig = b;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    public void reset() {
        springGroovyResourcesBeanBuilder = null;
    }
}

