/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.GriffonService;
import griffon.core.ServiceManager;
import griffon.spring.ApplicationContextHolder;
import java.util.Collections;
import java.util.Map;
import org.codehaus.griffon.runtime.core.AbstractServiceManager;
import org.codehaus.griffon.runtime.core.DefaultGriffonServiceClass;
import org.codehaus.griffon.runtime.core.SpringArtifactHandlerAdapter;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpringServiceArtifactHandler
extends SpringArtifactHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SpringServiceArtifactHandler.class);
    private final ServiceManager serviceManager;

    SpringServiceArtifactHandler(GriffonApplication app) {
        super(app, "service", "Service");
        this.serviceManager = new SpringServiceManager(app);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering " + this.serviceManager + " as ServiceManager.");
        }
        InvokerHelper.setProperty((Object)app, (String)"serviceManager", (Object)this.serviceManager);
    }

    protected GriffonClass newGriffonClassInstance(Class clazz) {
        return new DefaultGriffonServiceClass(this.getApp(), clazz);
    }

    private class SpringServiceManager
    extends AbstractServiceManager {
        public SpringServiceManager(GriffonApplication app) {
            super(app);
        }

        public Map<String, GriffonService> getServices() {
            return Collections.unmodifiableMap(ApplicationContextHolder.getApplicationContext().getBeansOfType(GriffonService.class));
        }

        public GriffonService findService(String name) {
            if (!name.endsWith("Service")) {
                name = name + "Service";
            }
            return (GriffonService)ApplicationContextHolder.getApplicationContext().getBean(name);
        }
    }
}

