/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.splash;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.JLabel;

public class SplashScreen
implements ImageObserver {
    private Image image;
    private JLabel label = new JLabel("<html><br><span style=\"font-size:large;\">Loading...</span><br><br></html>", 0);
    private Frame frame;
    private long splashTime = 0L;
    private static SplashScreen instance;
    private static SplashScreen singleton;

    public SplashScreen(String filename) {
        this.setImage(filename);
    }

    public SplashScreen(URL url) {
        this.setImage(url);
    }

    public SplashScreen() {
    }

    public static SplashScreen getInstance() {
        if (instance == null) {
            instance = new SplashScreen();
            URL url = Thread.currentThread().getContextClassLoader().getResource("splash.png");
            instance.setImage(url);
        }
        return instance;
    }

    public void setImage(String filename) {
        this.image = Toolkit.getDefaultToolkit().getImage(filename);
    }

    public void setImage(URL url) {
        this.image = Toolkit.getDefaultToolkit().getImage(url);
    }

    public void splash(String filename) {
        this.splash(Toolkit.getDefaultToolkit().getImage(filename));
    }

    public void splash(URL url) {
        this.splash(Toolkit.getDefaultToolkit().getImage(url));
    }

    public void splash() {
        if (this.image != null) {
            this.splash(this.image);
        } else {
            this.splash(Toolkit.getDefaultToolkit().getImage("splash.png"));
        }
    }

    public void splash(Image img) {
        this.image = img;
        this.frame = new Frame();
        this.frame.setUndecorated(true);
        if (!Toolkit.getDefaultToolkit().prepareImage(this.image, -1, -1, this)) {
            return;
        }
        this.splashScreen();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean allbits;
        boolean bl = allbits = infoflags == 32;
        if (allbits) {
            this.splashScreen();
        }
        return !allbits;
    }

    private synchronized void splashScreen() {
        if (this.frame == null) {
            return;
        }
        final int width = this.image.getWidth(null);
        final int height = this.image.getHeight(null);
        Canvas canvas = new Canvas(){

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }

            @Override
            public void paint(Graphics g) {
                g.drawImage(SplashScreen.this.image, 0, 0, this);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(width, height);
            }
        };
        this.frame.add((Component)canvas, "Center");
        this.frame.add((Component)this.label, "South");
        this.frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        this.frame.setLocation(screenSize.width - frameSize.width >> 1, screenSize.height - frameSize.height >> 1);
        this.frame.show();
        this.splashTime = System.currentTimeMillis();
    }

    public void showStatus(String s) {
        this.label.setText(s);
    }

    public void waitForSplash() {
        MediaTracker mt = new MediaTracker(this.frame);
        mt.addImage(this.image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitForSplash(long ms) {
        MediaTracker mt = new MediaTracker(this.frame);
        mt.addImage(this.image, 0);
        try {
            mt.waitForID(0, ms);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    public void delayForSplash() {
        int cpus = Runtime.getRuntime().availableProcessors();
        switch (cpus) {
            case 0: 
            case 1: {
                this.waitForSplash();
                break;
            }
            case 2: 
            case 3: {
                this.waitForSplash(1000 / cpus);
            }
        }
    }

    public synchronized void splashFor(int ms) {
        if (this.splashTime == 0L) {
            return;
        }
        long splashDuration = System.currentTimeMillis() - this.splashTime;
        if (splashDuration < (long)ms) {
            try {
                Thread.sleep((long)ms - splashDuration);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public synchronized void dispose() {
        this.frame.remove(this.label);
        this.frame.dispose();
        this.frame = null;
        this.splashTime = 0L;
    }

    public static synchronized SplashScreen instance() {
        if (null == singleton) {
            singleton = new SplashScreen();
        }
        return singleton;
    }

    static {
        singleton = null;
    }
}

