/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.splash;

import griffon.core.GriffonApplication;
import griffon.core.UIThreadManager;
import griffon.plugins.splash.DefaultSplashScreenProvider;
import griffon.plugins.splash.SplashScreenProvider;
import griffon.util.ApplicationClassLoader;
import java.net.URL;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class SplashScreen {
    private static SplashScreen INSTANCE;
    private static final Object LOCK;
    private Stage stage = new Stage();
    private SplashScreenProvider splashScreenProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void show(final GriffonApplication app) {
        Object object = LOCK;
        synchronized (object) {
            UIThreadManager.getInstance().executeSync(new Runnable(){

                @Override
                public void run() {
                    if (null == INSTANCE) {
                        SplashScreen.createSplashScreen(app);
                    }
                    INSTANCE.stage.show();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hide() {
        Object object = LOCK;
        synchronized (object) {
            UIThreadManager.getInstance().executeAsync(new Runnable(){

                @Override
                public void run() {
                    if (null != INSTANCE) {
                        INSTANCE.stage.hide();
                    }
                    INSTANCE = null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateStatus(final String message) {
        Object object = LOCK;
        synchronized (object) {
            if (null == INSTANCE) {
                return;
            }
            UIThreadManager.getInstance().executeAsync(new Runnable(){

                @Override
                public void run() {
                    INSTANCE.splashScreenProvider.setMessage(message);
                }
            });
        }
    }

    private static void createSplashScreen(GriffonApplication app) {
        INSTANCE = new SplashScreen(app);
        app.addApplicationEventListener((Object)INSTANCE);
    }

    private SplashScreen(GriffonApplication app) {
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.setScene(this.createScene(app));
        this.stage.sizeToScene();
    }

    private Scene createScene(GriffonApplication app) {
        if (null == this.splashScreenProvider) {
            this.initSplashScreenProvider();
        }
        return this.splashScreenProvider.getScene(app);
    }

    public void onWindowShown(Window window) {
        if (window != this.stage) {
            this.stage.toFront();
        }
    }

    public void onReadyEnd(GriffonApplication app) {
        SplashScreen.hide();
        app.removeApplicationEventListener((Object)this);
    }

    private void initSplashScreenProvider() {
        ClassLoader classLoader = ApplicationClassLoader.get();
        try {
            URL url = classLoader.getResource("META-INF/services/" + SplashScreenProvider.class.getName());
            String className = DefaultGroovyMethods.getText((URL)url).trim();
            this.splashScreenProvider = (SplashScreenProvider)classLoader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            this.splashScreenProvider = new DefaultSplashScreenProvider();
        }
    }

    static {
        LOCK = new Object[0];
    }
}

