/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compiler.support;

import griffon.plugins.slideware.GriffonSlide;
import org.codehaus.griffon.compiler.support.GriffonArtifactASTTransformation;
import org.codehaus.griffon.compiler.support.GriffonSlideASTInjector;
import org.codehaus.griffon.runtime.slideware.AbstractGriffonSlideScript;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class GriffonSlideASTTransformation
extends GriffonArtifactASTTransformation {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonSlideASTTransformation.class);
    private static final String ARTIFACT_PATH = "slides";
    private static final ClassNode GRIFFON_SLIDE_CLASS = ClassHelper.makeWithoutCaching(GriffonSlide.class);
    private static final ClassNode ABSTRACT_GRIFFON_SLIDE_SCRIPT_CLASS = ClassHelper.makeWithoutCaching(AbstractGriffonSlideScript.class);

    protected boolean allowsScriptAsArtifact() {
        return true;
    }

    protected void transform(ClassNode classNode, SourceUnit source, String artifactPath) {
        if (!ARTIFACT_PATH.equals(artifactPath) || !classNode.getName().endsWith("Slide")) {
            return;
        }
        if (classNode.isDerivedFrom(ClassHelper.SCRIPT_TYPE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting " + ABSTRACT_GRIFFON_SLIDE_SCRIPT_CLASS.getName() + " as the superclass of " + classNode.getName());
            }
            classNode.setSuperClass(ABSTRACT_GRIFFON_SLIDE_SCRIPT_CLASS);
        } else if (!classNode.implementsInterface(GRIFFON_SLIDE_CLASS)) {
            this.inject(classNode);
        }
    }

    private void inject(ClassNode classNode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Injecting " + GRIFFON_SLIDE_CLASS.getName() + " behavior to " + classNode.getName());
        }
        classNode.addInterface(GRIFFON_SLIDE_CLASS);
        GriffonSlideASTInjector injector = new GriffonSlideASTInjector();
        injector.inject(classNode, "slide");
    }
}

