/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.slideware;

import griffon.plugins.slideware.BackgroundPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImagePanel
extends BackgroundPanel {
    private static final Color TRANSPARENT = new Color(255, 0, 0, 255);
    private float scale = 1.0f;
    private Image image;
    private boolean centerImage = true;

    public ImagePanel() {
        this.setBackground(TRANSPARENT);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.clearCache();
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.clearCache();
        this.repaint();
    }

    public boolean isCenterImage() {
        return this.centerImage;
    }

    public void setCenterImage(boolean centerImage) {
        this.centerImage = centerImage;
        this.clearCache();
        this.repaint();
    }

    public void setImagePath(String imagePath) {
        try {
            this.image = ImageIO.read(Thread.currentThread().getContextClassLoader().getResource(imagePath));
            this.clearCache();
            this.repaint();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Image image = this.getImage();
        if (image == null) {
            return new Dimension(0, 0);
        }
        float width = (float)image.getWidth(null) * this.getScale();
        float height = (float)image.getHeight(null) * this.getScale();
        return new Dimension((int)width, (int)height);
    }

    @Override
    protected void paintImage(Graphics2D g, Rectangle bounds) {
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Image image = this.getImage();
        if (image != null) {
            Dimension pref = this.getPreferredSize();
            float width = pref.width;
            float height = pref.height;
            if (width > (float)bounds.width || height > (float)bounds.height) {
                float f = Math.min((float)bounds.width / width, (float)bounds.height / height);
                width *= f;
                height *= f;
            }
            int x = 0;
            int y = 0;
            if (this.centerImage) {
                x = (int)(((float)bounds.width - width) / 2.0f);
                y = (int)(((float)bounds.height - height) / 2.0f);
            }
            g.drawImage(image, x, y, (int)width, (int)height, null);
        }
    }
}

