/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.slideware;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class GraphicsUtil {
    public static BufferedImage createCompatibleImage(int width, int height) {
        return GraphicsUtil.createCompatibleImage(width, height, false);
    }

    public static BufferedImage createCompatibleImage(int width, int height, boolean withAlpha) {
        if (GraphicsEnvironment.isHeadless()) {
            return new BufferedImage(width, height, withAlpha ? 2 : 1);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, withAlpha ? 3 : 1);
    }

    public static Rectangle scaleBounds(int w, int h, Rectangle bounds) {
        return GraphicsUtil.scaleBounds(w, h, bounds, 0.9f);
    }

    public static Rectangle scaleBounds(int w, int h, Rectangle bounds, float fitAmount) {
        fitAmount = fitAmount >= 0.0f && fitAmount <= 1.0f ? fitAmount : 0.9f;
        int width = w;
        int height = h;
        if (height > bounds.height) {
            height = (int)((float)bounds.height * fitAmount);
            width = w * height / h;
        }
        if (width > bounds.width) {
            width = (int)((float)bounds.height * fitAmount);
            height = h * width / w;
        }
        int x = bounds.x + (bounds.width - width) / 2;
        int y = bounds.y + (bounds.height - height) / 2;
        return new Rectangle(x, y, width, height);
    }

    public static void scaleAndDrawImage(Graphics g, float scale, String imageResource) {
        try {
            GraphicsUtil.scaleAndDrawImage(g, scale, ImageIO.read(Thread.currentThread().getContextClassLoader().getResource(imageResource)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void scaleAndDrawImage(Graphics g, float scale, Image image) {
        float width = (float)image.getWidth(null) * scale;
        float height = (float)image.getHeight(null) * scale;
        g.drawImage(image, 0, 0, (int)width, (int)height, null);
    }
}

