/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.slideware;

import griffon.plugins.slideware.GraphicsUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class DrawingPanel
extends JPanel {
    protected Rectangle previousBounds;
    protected Image cachedImage;

    @Override
    protected void paintComponent(Graphics g) {
        if (this.previousBounds == null) {
            this.previousBounds = new Rectangle();
            this.getBounds(this.previousBounds);
        }
        if (this.cachedImage == null || !this.equals(this.previousBounds, this.getBounds())) {
            this.getBounds(this.previousBounds);
            this.cachedImage = this.createImage();
        }
        g.drawImage(this.cachedImage, 0, 0, this);
    }

    public void clearCache() {
        this.previousBounds = null;
        this.cachedImage = null;
    }

    private boolean equals(Rectangle a, Rectangle b) {
        return a.x == b.x && b.y == b.y && a.width == b.width && a.height == b.height;
    }

    private Image createImage() {
        Rectangle bounds = this.getBounds();
        BufferedImage image = GraphicsUtil.createCompatibleImage(bounds.width, bounds.height, true);
        Graphics2D g = image.createGraphics();
        this.paintImage(g, bounds);
        g.dispose();
        return image;
    }

    protected abstract void paintImage(Graphics2D var1, Rectangle var2);
}

