/*
 * Decompiled with CFR 0.152.
 */
package simplejpa.artifact.repository;

import griffon.core.ArtifactInfo;
import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.ShutdownHandler;
import griffon.exceptions.NewInstanceCreationException;
import griffon.util.ConfigUtils;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.griffon.runtime.core.ArtifactHandlerAdapter;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import simplejpa.SimpleJpaUtil;
import simplejpa.artifact.repository.DefaultRepositoryClass;
import simplejpa.artifact.repository.RepositoryManager;

public class RepositoryArtifactHandler
extends ArtifactHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryArtifactHandler.class);
    private final RepositoryManager repositoryManager = new AbstractRepositoryManager();

    public RepositoryArtifactHandler(GriffonApplication app) {
        super(app, "repository", "Repository");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering " + this.repositoryManager + " to SimpleJpaUtil.");
        }
        SimpleJpaUtil.instance.setRepositoryManager(this.repositoryManager);
    }

    protected GriffonClass newGriffonClassInstance(Class clazz) {
        return new DefaultRepositoryClass(this.getApp(), clazz);
    }

    public void initialize(ArtifactInfo[] artifacts) {
        super.initialize(artifacts);
        this.getApp().addApplicationEventListener((Object)this);
        if (this.isEagerInstantiationEnabled()) {
            GriffonClass griffonClass;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Instantiating repository instances eagerly");
            }
            for (ArtifactInfo artifactInfo : artifacts) {
                griffonClass = this.getClassFor(artifactInfo.getClazz());
                this.repositoryManager.doInstantiate(griffonClass.getPropertyName(), false);
            }
            for (ArtifactInfo artifactInfo : artifacts) {
                griffonClass = this.getClassFor(artifactInfo.getClazz());
                Object repositoryInstance = this.repositoryManager.findRepository(griffonClass.getPropertyName());
                this.getApp().event(GriffonApplication.Event.NEW_INSTANCE.getName(), Arrays.asList(griffonClass.getClazz(), "repository", repositoryInstance));
            }
        }
    }

    public void onNewInstance(Class klass, String t, Object instance) {
        MetaClass metaClass = InvokerHelper.getMetaClass((Object)instance);
        for (MetaProperty property : metaClass.getProperties()) {
            Object repositoryInstance;
            String propertyName = property.getName();
            if (!propertyName.endsWith(this.getTrailing()) || (repositoryInstance = this.repositoryManager.findRepository(propertyName)) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting repository " + repositoryInstance + " on " + instance + " using property '" + propertyName + "'");
            }
            InvokerHelper.setProperty((Object)instance, (String)propertyName, (Object)repositoryInstance);
        }
    }

    private boolean isEagerInstantiationEnabled() {
        return ConfigUtils.getConfigValueAsBoolean((Map)this.getApp().getConfig(), (String)"griffon.simplejpa.repository.eager_instantiation", (boolean)false);
    }

    public class AbstractRepositoryManager
    implements RepositoryManager {
        private final Map<String, Object> instances = new ConcurrentHashMap<String, Object>();

        public AbstractRepositoryManager() {
            RepositoryArtifactHandler.this.getApp().addShutdownHandler((ShutdownHandler)new RepositoryManagerShutdownHandler());
        }

        @Override
        public Map<String, Object> getRepositories() {
            return Collections.unmodifiableMap(this.instances);
        }

        @Override
        public Object findRepository(String name) {
            Object repositoryInstance;
            if (!name.endsWith("Repository")) {
                name = name + "Repository";
            }
            if ((repositoryInstance = this.instances.get(name = GriffonNameUtils.getPropertyNameRepresentation((String)name))) == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Instantiating repository identified by '" + name + "'");
                }
                repositoryInstance = this.doInstantiate(name, true);
            }
            return repositoryInstance;
        }

        @Override
        public Object doInstantiate(String name, boolean triggerEvent) {
            Object instance = null;
            GriffonClass griffonClass = RepositoryArtifactHandler.this.findClassFor(name);
            if (griffonClass != null) {
                try {
                    instance = griffonClass.getClazz().newInstance();
                }
                catch (Exception e) {
                    Throwable targetException = null;
                    targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                    throw new NewInstanceCreationException("Could not create a new instance of class " + griffonClass.getClazz().getName(), GriffonExceptionHandler.sanitize((Throwable)targetException));
                }
                this.instances.put(name, instance);
                if (griffonClass.hasProperty("app")) {
                    InvokerHelper.setProperty(instance, (String)"app", (Object)RepositoryArtifactHandler.this.getApp());
                }
                RepositoryArtifactHandler.this.getApp().addApplicationEventListener(instance);
                if (triggerEvent) {
                    RepositoryArtifactHandler.this.getApp().event(GriffonApplication.Event.NEW_INSTANCE.getName(), Arrays.asList(griffonClass.getClazz(), "repository", instance));
                }
            }
            return instance;
        }

        private class RepositoryManagerShutdownHandler
        implements ShutdownHandler {
            private RepositoryManagerShutdownHandler() {
            }

            public boolean canShutdown(GriffonApplication application) {
                return true;
            }

            public void onShutdown(GriffonApplication application) {
                for (Map.Entry entry : AbstractRepositoryManager.this.instances.entrySet()) {
                    Object repository = entry.getValue();
                    application.removeApplicationEventListener(repository);
                    application.event(GriffonApplication.Event.DESTROY_INSTANCE.getName(), Arrays.asList(repository.getClass(), "repository", repository));
                }
            }
        }
    }
}

