/*
 * Copyright 2013 Jocki Hendry.
 *
 * Licensed under the Apache License, Version 2.0 (the 'License');
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an 'AS IS' BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



package simplejpa.swing.glazed.renderer

import javax.swing.*
import javax.swing.table.TableCellRenderer
import java.awt.*

class DefaultTableHeaderRenderer implements TableCellRenderer {

    Map propertyValues = [:]

    public void addPropertyValue(String method, Object value) {
        propertyValues[method] = value
    }

    @Override
    Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, value,
            isSelected, hasFocus, row, column)
        propertyValues.each { String k, Object v ->
            component.metaClass.setProperty(component, k, v)
        }
        component.updateUI()
        component
    }

}
