/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.griffon.runtime.shiro;

import griffon.core.GriffonApplication;
import griffon.plugins.shiro.factory.SecurityManagerFactory;
import griffon.util.ConfigUtils;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.text.PropertiesRealm;

/**
 * @author Andres Almiray
 */
public class DefaultSecurityManagerFactory implements SecurityManagerFactory {
    private static final String DEFAULT_REALM_RESOURCE_PATH = "classpath:shiro-users.properties";
    private static final String KEY_REALM_RESOURCE_PATH = "shiro.realm.resource.path";

    public SecurityManager createSecurityManager(GriffonApplication app) {
        PropertiesRealm realm = new PropertiesRealm();
        String resourcePath = ConfigUtils.getConfigValueAsString(app.getConfig(), KEY_REALM_RESOURCE_PATH, DEFAULT_REALM_RESOURCE_PATH);
        realm.setResourcePath(resourcePath);
        realm.init();
        return new DefaultSecurityManager(realm);
    }
}
