/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.shiro;

import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.plugins.shiro.SecurityFailureHandler;
import griffon.plugins.shiro.SubjectHolder;
import griffon.plugins.shiro.annotation.Logical;
import griffon.plugins.shiro.annotation.RequiresAuthentication;
import griffon.plugins.shiro.annotation.RequiresGuest;
import griffon.plugins.shiro.annotation.RequiresPermissions;
import griffon.plugins.shiro.annotation.RequiresRoles;
import griffon.util.ConfigUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.subject.Subject;
import org.codehaus.griffon.runtime.core.controller.AbstractGriffonControllerActionInterceptor;
import org.codehaus.griffon.runtime.shiro.SecurityFailureHandlerResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroGriffonControllerActionInterceptor
extends AbstractGriffonControllerActionInterceptor {
    private final Logger LOG = LoggerFactory.getLogger(ShiroGriffonControllerActionInterceptor.class);
    private final Map<String, ActionRequirement> requirementsPerAction = new LinkedHashMap<String, ActionRequirement>();
    SecurityFailureHandler securityFailureHandler;
    private static final String DEFAULT_SECURITY_FAILURE_HANDLER = "org.codehaus.griffon.runtime.shiro.DefaultSecurityFailureHandler";
    private static final String KEY_SECURITY_FAILURE_HANDLER = "shiro.security.failure.handler";

    public void configure(GriffonController controller, String actionName, Method method) {
        this.configureAction(controller, actionName, method);
    }

    public void configure(GriffonController controller, String actionName, Field closure) {
        this.configureAction(controller, actionName, closure);
    }

    public Object[] before(GriffonController controller, String actionName, Object[] args) {
        String fqActionName = this.qualifyActionName(controller, actionName);
        ActionRequirement actionRequirement = this.requirementsPerAction.get(fqActionName);
        if (actionRequirement != null) {
            Subject subject = SubjectHolder.getSubject();
            for (RequirementConfiguration requirementConfiguration : actionRequirement.getRequirements()) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Evaluating security requirement " + requirementConfiguration);
                }
                if (requirementConfiguration.eval(subject)) continue;
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Subject did not meet expected security requirements.");
                }
                switch (requirementConfiguration.requirement) {
                    case AUTHENTICATION: {
                        this.securityFailureHandler.handleFailure(subject, SecurityFailureHandler.Kind.AUTHENTICATION, controller, actionName);
                        break;
                    }
                    case ROLES: {
                        this.securityFailureHandler.handleFailure(subject, SecurityFailureHandler.Kind.ROLES, controller, actionName);
                        break;
                    }
                    case PERMISSIONS: {
                        this.securityFailureHandler.handleFailure(subject, SecurityFailureHandler.Kind.PERMISSIONS, controller, actionName);
                        break;
                    }
                    default: {
                        this.securityFailureHandler.handleFailure(subject, SecurityFailureHandler.Kind.GUEST, controller, actionName);
                    }
                }
                throw this.abortActionExecution();
            }
        }
        return args;
    }

    public void setApp(GriffonApplication app) {
        super.setApp(app);
        String handlerClassName = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), (String)KEY_SECURITY_FAILURE_HANDLER, (String)DEFAULT_SECURITY_FAILURE_HANDLER);
        this.securityFailureHandler = new SecurityFailureHandlerResolver(app, this, handlerClassName);
    }

    private void configureAction(GriffonController controller, String actionName, AnnotatedElement annotatedElement) {
        String fqActionName = this.qualifyActionName(controller, actionName);
        if (this.requirementsPerAction.get(fqActionName) != null) {
            return;
        }
        LinkedHashMap<Requirement, RequirementConfiguration> requirements = new LinkedHashMap<Requirement, RequirementConfiguration>();
        this.processRequiresGuest(controller.getClass().getAnnotation(RequiresGuest.class), requirements);
        this.processRequiresAuthentication(controller.getClass().getAnnotation(RequiresAuthentication.class), requirements);
        this.processRequiresRoles(controller.getClass().getAnnotation(RequiresRoles.class), requirements);
        this.processRequiresPermissions(controller.getClass().getAnnotation(RequiresPermissions.class), requirements);
        this.processRequiresGuest(annotatedElement.getAnnotation(RequiresGuest.class), requirements);
        this.processRequiresAuthentication(annotatedElement.getAnnotation(RequiresAuthentication.class), requirements);
        this.processRequiresRoles(annotatedElement.getAnnotation(RequiresRoles.class), requirements);
        this.processRequiresPermissions(annotatedElement.getAnnotation(RequiresPermissions.class), requirements);
        this.requirementsPerAction.put(fqActionName, new ActionRequirement(fqActionName, requirements.values().toArray(new RequirementConfiguration[requirements.size()])));
    }

    private void processRequiresAuthentication(RequiresAuthentication annotation, Map<Requirement, RequirementConfiguration> requirements) {
        if (annotation == null) {
            return;
        }
        requirements.remove((Object)Requirement.GUEST);
        requirements.put(Requirement.AUTHENTICATION, new RequirementConfiguration(Requirement.AUTHENTICATION));
    }

    private void processRequiresRoles(RequiresRoles annotation, Map<Requirement, RequirementConfiguration> requirements) {
        if (annotation == null) {
            return;
        }
        String[] value = annotation.value();
        Logical logical = annotation.logical();
        requirements.remove((Object)Requirement.GUEST);
        requirements.put(Requirement.ROLES, new RequirementConfiguration(Requirement.ROLES, value, logical));
    }

    private void processRequiresPermissions(RequiresPermissions annotation, Map<Requirement, RequirementConfiguration> requirements) {
        if (annotation == null) {
            return;
        }
        String[] value = annotation.value();
        Logical logical = annotation.logical();
        requirements.remove((Object)Requirement.GUEST);
        requirements.put(Requirement.PERMISSIONS, new RequirementConfiguration(Requirement.PERMISSIONS, value, logical));
    }

    private void processRequiresGuest(RequiresGuest annotation, Map<Requirement, RequirementConfiguration> requirements) {
        if (annotation == null) {
            return;
        }
        requirements.clear();
        requirements.put(Requirement.GUEST, new RequirementConfiguration(Requirement.GUEST));
    }

    private static class RequirementConfiguration {
        private static final String[] EMPTY = new String[0];
        private final Requirement requirement;
        private final String[] values;
        private final Logical logical;

        private RequirementConfiguration(Requirement requirement) {
            this(requirement, EMPTY, Logical.AND);
        }

        private RequirementConfiguration(Requirement requirement, String[] values, Logical logical) {
            this.requirement = requirement;
            this.values = values;
            this.logical = logical;
        }

        public Requirement getRequirement() {
            return this.requirement;
        }

        public String[] getValues() {
            return this.values;
        }

        public Logical getLogical() {
            return this.logical;
        }

        public boolean eval(Subject subject) {
            return this.requirement.eval(this, subject);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequirementConfiguration that = (RequirementConfiguration)o;
            if (this.logical != that.logical) {
                return false;
            }
            if (this.requirement != that.requirement) {
                return false;
            }
            return Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            int result = this.requirement.hashCode();
            result = 31 * result + Arrays.hashCode(this.values);
            result = 31 * result + this.logical.hashCode();
            return result;
        }

        public String toString() {
            return "RequirementConfiguration{requirement=" + (Object)((Object)this.requirement) + ", values=" + (this.values == null ? null : Arrays.asList(this.values)) + ", logical=" + (Object)((Object)this.logical) + '}';
        }
    }

    private static class ActionRequirement {
        private final String actionName;
        private final RequirementConfiguration[] requirements;

        private ActionRequirement(String actionName, RequirementConfiguration[] requirements) {
            this.actionName = actionName;
            this.requirements = requirements;
        }

        public String getActionName() {
            return this.actionName;
        }

        public RequirementConfiguration[] getRequirements() {
            return this.requirements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionRequirement that = (ActionRequirement)o;
            if (!this.actionName.equals(that.actionName)) {
                return false;
            }
            return Arrays.equals(this.requirements, that.requirements);
        }

        public int hashCode() {
            int result = this.actionName.hashCode();
            result = 31 * result + Arrays.hashCode(this.requirements);
            return result;
        }

        public String toString() {
            return "ActionRequirement{actionName='" + this.actionName + '\'' + ", requirements=" + (this.requirements == null ? null : Arrays.asList(this.requirements)) + '}';
        }
    }

    private static class PermissionsRequirementEvaluator
    implements RequirementEvaluator {
        private PermissionsRequirementEvaluator() {
        }

        @Override
        public boolean eval(RequirementConfiguration requirementConfig, Subject subject) {
            block6: {
                String[] perms = requirementConfig.getValues();
                Logical logical = requirementConfig.getLogical();
                try {
                    if (perms.length == 1) {
                        subject.checkPermission(perms[0]);
                        break block6;
                    }
                    if (Logical.AND.equals((Object)logical)) {
                        subject.checkPermissions(perms);
                        break block6;
                    }
                    if (!Logical.OR.equals((Object)logical)) break block6;
                    boolean hasAtLeastOnePermission = false;
                    for (String permission : perms) {
                        if (!subject.isPermitted(permission)) continue;
                        hasAtLeastOnePermission = true;
                    }
                    if (!hasAtLeastOnePermission) {
                        subject.checkPermission(perms[0]);
                        break block6;
                    }
                    return true;
                }
                catch (AuthorizationException ae) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class RolesRequirementEvaluator
    implements RequirementEvaluator {
        private RolesRequirementEvaluator() {
        }

        @Override
        public boolean eval(RequirementConfiguration requirementConfig, Subject subject) {
            block6: {
                String[] roles = requirementConfig.getValues();
                Logical logical = requirementConfig.getLogical();
                try {
                    if (roles.length == 1) {
                        subject.checkRole(roles[0]);
                        break block6;
                    }
                    if (Logical.AND.equals((Object)logical)) {
                        subject.checkRoles(Arrays.asList(roles));
                        break block6;
                    }
                    if (!Logical.OR.equals((Object)logical)) break block6;
                    boolean hasAtLeastOneRole = false;
                    for (String role : roles) {
                        if (!subject.hasRole(role)) continue;
                        hasAtLeastOneRole = true;
                    }
                    if (!hasAtLeastOneRole) {
                        subject.checkRole(roles[0]);
                        break block6;
                    }
                    return true;
                }
                catch (AuthorizationException ae) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class GuestRequirementEvaluator
    implements RequirementEvaluator {
        private GuestRequirementEvaluator() {
        }

        @Override
        public boolean eval(RequirementConfiguration requirementConfig, Subject subject) {
            return subject.getPrincipal() == null;
        }
    }

    private static class AuthenticationRequirementEvaluator
    implements RequirementEvaluator {
        private AuthenticationRequirementEvaluator() {
        }

        @Override
        public boolean eval(RequirementConfiguration requirementConfig, Subject subject) {
            return subject.isAuthenticated();
        }
    }

    private static interface RequirementEvaluator {
        public boolean eval(RequirementConfiguration var1, Subject var2);
    }

    private static enum Requirement {
        AUTHENTICATION(new AuthenticationRequirementEvaluator()),
        ROLES(new RolesRequirementEvaluator()),
        PERMISSIONS(new PermissionsRequirementEvaluator()),
        GUEST(new GuestRequirementEvaluator());

        private final RequirementEvaluator requirementEvaluator;

        private Requirement(RequirementEvaluator requirementEvaluator) {
            this.requirementEvaluator = requirementEvaluator;
        }

        private boolean eval(RequirementConfiguration requirementConfig, Subject subject) {
            return this.requirementEvaluator.eval(requirementConfig, subject);
        }
    }
}

