/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.shiro;

import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.plugins.shiro.SecurityFailureHandler;
import org.apache.shiro.subject.Subject;
import org.codehaus.griffon.runtime.shiro.ShiroGriffonControllerActionInterceptor;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;

public class SecurityFailureHandlerResolver
implements SecurityFailureHandler {
    private final GriffonApplication app;
    private final ShiroGriffonControllerActionInterceptor interceptor;
    private final String handlerClassName;

    public SecurityFailureHandlerResolver(GriffonApplication app, ShiroGriffonControllerActionInterceptor interceptor, String handlerClassName) {
        this.app = app;
        this.interceptor = interceptor;
        this.handlerClassName = handlerClassName;
    }

    @Override
    public void handleFailure(Subject subject, SecurityFailureHandler.Kind kind, GriffonController controller, String actionName) {
        SecurityFailureHandler securityFailureHandler;
        Class handlerClass = GriffonApplicationHelper.safeLoadClass((String)this.handlerClassName);
        this.interceptor.securityFailureHandler = securityFailureHandler = (SecurityFailureHandler)this.app.newInstance(handlerClass, "");
        securityFailureHandler.handleFailure(subject, kind, controller, actionName);
    }
}

