/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.shiro;

import griffon.core.GriffonController;
import griffon.plugins.shiro.SecurityFailureHandler;
import org.apache.shiro.subject.Subject;
import org.codehaus.griffon.runtime.shiro.AbstractSecurityFailureHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityFailureHandler
extends AbstractSecurityFailureHandler {
    private final Logger LOG = LoggerFactory.getLogger(DefaultSecurityFailureHandler.class);

    @Override
    public void handleFailure(Subject subject, SecurityFailureHandler.Kind kind, GriffonController controller, String actionName) {
        if (this.LOG.isInfoEnabled()) {
            switch (kind) {
                case AUTHENTICATION: {
                    this.LOG.info("Subject failed authentication challenge on " + this.qualifyActionName(controller, actionName));
                    break;
                }
                case PERMISSIONS: {
                    this.LOG.info("Subject was not granted access to " + this.qualifyActionName(controller, actionName) + " due to lack of permissions");
                    break;
                }
                case ROLES: {
                    this.LOG.info("Subject was not granted access to " + this.qualifyActionName(controller, actionName) + " due to lack of roles");
                    break;
                }
                default: {
                    this.LOG.info("Subject failed guest challenge on " + this.qualifyActionName(controller, actionName));
                }
            }
        }
    }
}

