/*
 * Decompiled with CFR 0.152.
 */
import griffon.core.GriffonApplication;
import griffon.plugins.shiro.SubjectHolder;
import griffon.plugins.shiro.factory.SecurityManagerFactory;
import griffon.util.ApplicationHolder;
import griffon.util.CollectionUtils;
import griffon.util.ConfigUtils;
import griffon.util.RunnableWithArgs;
import griffon.util.RunnableWithArgsClosure;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.SecurityManager;
import org.codehaus.griffon.runtime.core.AbstractGriffonAddon;
import org.codehaus.griffon.runtime.shiro.ShiroGriffonControllerActionInterceptor;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;

public class ShiroGriffonAddon
extends AbstractGriffonAddon {
    private static final String DEFAULT_SECURITY_MANAGER_FACTORY = "org.codehaus.griffon.runtime.shiro.DefaultSecurityManagerFactory";
    private static final String KEY_SECURITY_MANAGER_FACTORY = "shiro.security.manager.factory";

    public ShiroGriffonAddon() {
        super(ApplicationHolder.getApplication());
        this.actionInterceptors.put("security", CollectionUtils.map().e((Object)"interceptor", (Object)ShiroGriffonControllerActionInterceptor.class.getName()));
        this.events.put(GriffonApplication.Event.LOAD_ADDONS_END.getName(), new RunnableWithArgsClosure(new RunnableWithArgs(){

            public void run(Object[] args) {
                ShiroGriffonAddon.this.initialize();
            }
        }));
    }

    private void initialize() {
        String className = ConfigUtils.getConfigValueAsString((Map)this.getApp().getConfig(), (String)KEY_SECURITY_MANAGER_FACTORY, (String)DEFAULT_SECURITY_MANAGER_FACTORY);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Using " + className + " as SecurityManagerFactory");
        }
        Class factoryClass = GriffonApplicationHelper.safeLoadClass((String)className);
        SecurityManagerFactory factory = (SecurityManagerFactory)this.getApp().newInstance(factoryClass, "");
        SecurityUtils.setSecurityManager((SecurityManager)factory.createSecurityManager(this.getApp()));
        SubjectHolder.setSubject(SecurityUtils.getSubject());
    }
}

