/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req.filter;

import com.senseidb.search.client.json.JsonHandler;
import com.senseidb.search.client.json.JsonSerializer;
import com.senseidb.search.client.json.req.Selection;
import com.senseidb.search.client.json.req.SelectionJsonHandler;
import com.senseidb.search.client.json.req.filter.BoolFilter;
import com.senseidb.search.client.json.req.filter.Filter;
import com.senseidb.search.client.json.req.filter.Ids;
import com.senseidb.search.client.json.req.filter.QueryFilter;
import com.senseidb.search.client.json.req.query.Query;
import com.senseidb.search.client.json.req.query.QueryJsonHandler;
import com.senseidb.search.client.json.req.query.StringQuery;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FilterJsonHandler
implements JsonHandler<Filter> {
    private SelectionJsonHandler selectionJsonHandler = new SelectionJsonHandler();
    private QueryJsonHandler queryJsonHandler = new QueryJsonHandler();

    @Override
    public JSONObject serialize(Filter bean) throws JSONException {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Selection) {
            return this.selectionJsonHandler.serialize((Selection)bean);
        }
        if (bean instanceof StringQuery) {
            JSONObject ret = (JSONObject)JsonSerializer.serialize(bean);
            return new JSONObject().put("query", (Object)ret);
        }
        if (bean instanceof Filter.AndOr) {
            Filter.AndOr andOr = (Filter.AndOr)bean;
            String operation = andOr.getOperation().name();
            List<JSONObject> filters = this.convertToJson(andOr.filters);
            return new JSONObject().put(operation, (Object)new JSONArray(filters));
        }
        if (bean instanceof BoolFilter) {
            BoolFilter bool = (BoolFilter)bean;
            JSONObject ret = new JSONObject();
            if (bool.getMust() != null) {
                ret.put("must", (Object)new JSONArray(this.convertToJson(bool.getMust())));
            }
            if (bool.getMust_not() != null) {
                ret.put("must_not", (Object)new JSONArray(this.convertToJson(bool.getMust_not())));
            }
            if (bool.getShould() != null) {
                ret.put("should", (Object)new JSONArray(this.convertToJson(bool.getShould())));
            }
            return new JSONObject().put("bool", (Object)ret);
        }
        if (bean instanceof Ids) {
            Ids ids = (Ids)bean;
            JSONObject ret = new JSONObject();
            if (ids.getValues() != null) {
                ret.put("values", (Object)new JSONArray(ids.getValues()));
            }
            if (ids.getExcludes() != null) {
                ret.put("excludes", (Object)new JSONArray(ids.getExcludes()));
            }
            return new JSONObject().put("ids", (Object)ret);
        }
        if (bean instanceof Query) {
            return this.queryJsonHandler.serialize((Query)bean);
        }
        if (bean instanceof QueryFilter) {
            return new JSONObject().put("query", (Object)this.queryJsonHandler.serialize(((QueryFilter)bean).getQuery()));
        }
        throw new UnsupportedOperationException(bean.getClass() + " is not supported");
    }

    private List<JSONObject> convertToJson(List<Filter> filters2) throws JSONException {
        ArrayList<JSONObject> filters = new ArrayList<JSONObject>(filters2.size());
        for (Filter filter : filters2) {
            filters.add(this.serialize(filter));
        }
        return filters;
    }

    @Override
    public Filter deserialize(JSONObject json) throws JSONException {
        return null;
    }
}

