/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req;

import com.senseidb.search.client.json.CustomJsonHandler;
import com.senseidb.search.client.json.req.Facet;
import com.senseidb.search.client.json.req.FacetInit;
import com.senseidb.search.client.json.req.GroupBy;
import com.senseidb.search.client.json.req.Paging;
import com.senseidb.search.client.json.req.Selection;
import com.senseidb.search.client.json.req.Sort;
import com.senseidb.search.client.json.req.filter.Filter;
import com.senseidb.search.client.json.req.filter.FilterJsonHandler;
import com.senseidb.search.client.json.req.query.Query;
import com.senseidb.search.client.json.req.query.QueryJsonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SenseiClientRequest {
    private Integer count;
    private Integer from;
    private GroupBy groupBy;
    private List<Selection> selections = new ArrayList<Selection>();
    @CustomJsonHandler(value=QueryJsonHandler.class)
    private Query query;
    private Map<String, Map<String, FacetInit>> facetInit = new HashMap<String, Map<String, FacetInit>>();
    private List<Sort> sorts = new ArrayList<Sort>();
    private Map<String, Facet> facets = new HashMap<String, Facet>();
    private boolean fetchStored;
    private List<String> termVectors = new ArrayList<String>();
    private List<Integer> partitions = new ArrayList<Integer>();
    private boolean explain;
    private String routeParam;
    @CustomJsonHandler(value=FilterJsonHandler.class)
    private Filter filter;
    private Map<String, Object> templateMapping;

    public static Builder builder() {
        return new Builder();
    }

    public Paging getPaging() {
        return new Paging(this.count, this.from);
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public Map<String, Map<String, FacetInit>> getFacetInit() {
        return this.facetInit;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public Map<String, Facet> getFacets() {
        return this.facets;
    }

    public boolean isFetchStored() {
        return this.fetchStored;
    }

    public List<String> getTermVectors() {
        return this.termVectors;
    }

    public List<Integer> getPartitions() {
        return this.partitions;
    }

    public boolean isExplain() {
        return this.explain;
    }

    public String getRouteParam() {
        return this.routeParam;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Query getQuery() {
        return this.query;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Map<String, Object> getTemplateMapping() {
        return this.templateMapping;
    }

    public static class Builder {
        private SenseiClientRequest request = new SenseiClientRequest();

        public Builder paging(int count, int offset) {
            this.request.count = count;
            this.request.from = offset;
            return this;
        }

        public Builder fetchStored(boolean fetchStored) {
            this.request.fetchStored = fetchStored;
            return this;
        }

        public Builder partitions(List<Integer> partitions) {
            this.request.partitions = partitions;
            return this;
        }

        public Builder explain(boolean explain) {
            this.request.explain = explain;
            return this;
        }

        public Builder query(Query query) {
            this.request.query = query;
            return this;
        }

        public Builder groupBy(int top, String ... columns) {
            this.request.groupBy = new GroupBy(Arrays.asList(columns), top);
            return this;
        }

        public Builder groupBy(List<String> columns, int top) {
            this.request.groupBy = new GroupBy(columns, top);
            return this;
        }

        public Builder addSelection(Selection selection) {
            if (selection == null) {
                throw new IllegalArgumentException("The selectionContainer should be not null");
            }
            this.request.selections.add(selection);
            return this;
        }

        public Builder addFacetInit(String name, Map<String, FacetInit> facetInits) {
            this.request.facetInit.put(name, facetInits);
            return this;
        }

        public Builder addTemplateMapping(String name, Object value) {
            if (this.request.templateMapping == null) {
                this.request.templateMapping = new HashMap();
            }
            this.request.templateMapping.put(name, value);
            return this;
        }

        public Builder addSort(Sort sort) {
            if (sort == null) {
                throw new IllegalArgumentException("The sort should be not null");
            }
            this.request.sorts.add(sort);
            return this;
        }

        public Builder addTermVector(String term) {
            this.request.termVectors.add(term);
            return this;
        }

        public Builder addFacetInit(String name, String parameter, FacetInit facetInit) {
            if (!this.request.facetInit.containsKey(name)) {
                this.request.facetInit.put(name, new HashMap());
            }
            ((Map)this.request.facetInit.get(name)).put(parameter, facetInit);
            return this;
        }

        public Builder addFacet(String name, Facet facet) {
            this.request.facets.put(name, facet);
            return this;
        }

        public Builder routeParam(String routeParam) {
            this.request.routeParam = routeParam;
            return this;
        }

        public Builder filter(Filter filter) {
            this.request.filter = filter;
            return this;
        }

        public SenseiClientRequest build() {
            return this.request;
        }
    }
}

