/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req;

import com.senseidb.search.client.json.CustomJsonHandler;
import com.senseidb.search.client.json.JsonField;
import com.senseidb.search.client.json.req.Operator;
import com.senseidb.search.client.json.req.SelectionJsonHandler;
import com.senseidb.search.client.json.req.Term;
import com.senseidb.search.client.json.req.Terms;
import com.senseidb.search.client.json.req.filter.Filter;
import com.senseidb.search.client.json.req.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

@CustomJsonHandler(value=SelectionJsonHandler.class)
public abstract class Selection
implements Filter {
    private String field;

    public String getField() {
        return this.field;
    }

    public Selection setField(String field) {
        this.field = field;
        return this;
    }

    public static Selection terms(String field, String ... values) {
        if (values.length == 1) {
            return new Term(values[0]).setField(field);
        }
        return new Terms(Arrays.asList(values), new ArrayList<String>(), null).setField(field);
    }

    public static Selection terms(String field, List<String> values, List<String> excludes, Operator op) {
        return new Terms(values, excludes, op).setField(field);
    }

    public static Selection range(String field, String from, String to, boolean includeLower, boolean includeUpper) {
        return new Range(from, to, includeLower, includeUpper).setField(field);
    }

    public static Selection range(String field, String from, String to) {
        return new Range(from, to, true, true).setField(field);
    }

    public static Selection path(String field, String value, boolean strict, int depth) {
        return new Path(value, strict, depth).setField(field);
    }

    public static Selection custom(JSONObject custom) {
        return new Custom(custom);
    }

    public static class Custom
    extends Selection {
        private JSONObject custom;

        public Custom(JSONObject custom) {
            this.custom = custom;
        }

        public Custom() {
        }

        public JSONObject getCustom() {
            return this.custom;
        }
    }

    public static class Range
    extends Selection
    implements Query {
        private String from;
        private String to;
        @JsonField(value="include_lower")
        private boolean includeLower;
        @JsonField(value="include_upper")
        private boolean includeUpper;
        private Double boost;
        @JsonField(value="_noOptimize")
        private Boolean notOptimize;
        private String type;

        public Range() {
        }

        public Range(String from, String to, boolean includeLower, boolean includeUpper) {
            this.from = from;
            this.to = to;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
        }

        public Range(String from, String to, boolean includeLower, boolean includeUpper, double Doost, boolean noOptimize) {
            this.from = from;
            this.to = to;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
            this.boost = this.boost;
            this.notOptimize = noOptimize;
        }

        public Range(String from, String to, boolean includeLower, boolean includeUpper, Double boost, boolean noOptimize, String type) {
            this.from = from;
            this.to = to;
            this.includeLower = includeLower;
            this.includeUpper = includeUpper;
            this.boost = boost;
            this.notOptimize = noOptimize;
            this.type = type;
        }
    }

    public static class Path
    extends Selection {
        private String value;
        private boolean strict;
        private int depth;

        public Path(String value, boolean strict, int depth) {
            this.value = value;
            this.strict = strict;
            this.depth = depth;
        }

        public Path() {
        }
    }
}

