/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json;

import com.senseidb.search.client.json.JsonDeserializer;
import com.senseidb.search.client.json.JsonSerializer;
import com.senseidb.search.client.json.req.SenseiClientRequest;
import com.senseidb.search.client.json.res.SenseiResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SenseiServiceProxy {
    private static Log LOG = LogFactory.getLog(SenseiServiceProxy.class);
    private String host;
    private int port;

    public SenseiServiceProxy(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public SenseiResult sendSearchRequest(SenseiClientRequest request) {
        try {
            String requestStr = JsonSerializer.serialize(request).toString();
            String output = this.sendPostRaw(this.getSearchUrl(), requestStr);
            return JsonDeserializer.deserialize(SenseiResult.class, this.jsonResponse(output));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<Long, JSONObject> sendGetRequest(long ... uids) throws IOException, JSONException {
        LinkedHashMap<Long, JSONObject> ret = new LinkedHashMap<Long, JSONObject>(uids.length);
        String response = this.sendPostRaw(this.getStoreGetUrl(), new JSONArray((Object)uids).toString());
        if (response == null || response.length() == 0) {
            return ret;
        }
        JSONObject responseJson = new JSONObject(response);
        Iterator keys = responseJson.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            ret.put(Long.parseLong(key), responseJson.optJSONObject(key));
        }
        return ret;
    }

    public String getSearchUrl() {
        return "http://" + this.host + ":" + this.port + "/sensei";
    }

    public String getStoreGetUrl() {
        return "http://" + this.host + ":" + this.port + "/sensei/get";
    }

    private JSONObject jsonResponse(String output) throws JSONException {
        return new JSONObject(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] drain(InputStream inputStream) throws IOException {
        try {
            int len;
            byte[] buf = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((len = inputStream.read(buf)) > 0) {
                byteArrayOutputStream.write(buf, 0, len);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public String sendPostRaw(String urlStr, String requestStr) {
        return this.sendPostRaw(urlStr, requestStr, null);
    }

    public String sendPostRaw(String urlStr, String requestStr, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Sending a post request to the server - " + urlStr));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The request is - " + requestStr));
            }
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestProperty("Accept-Encoding", "gzip");
            String string = requestStr;
            byte[] requestBytes = string.getBytes("UTF-8");
            conn.setRequestProperty("Content-Length", String.valueOf(requestBytes.length));
            conn.setRequestProperty("http.keepAlive", String.valueOf(true));
            conn.setRequestProperty("default", String.valueOf(true));
            if (headers != null && headers.size() > 0) {
                Set<Map.Entry<String, String>> entries = headers.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream());
            ((OutputStream)os).write(requestBytes);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            int responseCode = conn.getResponseCode();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("The http response code is " + responseCode));
            }
            if (responseCode != 200) {
                throw new IOException("Failed : HTTP error code : " + responseCode);
            }
            byte[] bytes = this.drain(new GZIPInputStream(new BufferedInputStream(conn.getInputStream())));
            String output = new String(bytes, "UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The response from the server is - " + output));
            }
            String string2 = output;
            return string2;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

