/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req.query;

import com.senseidb.search.client.json.CustomJsonHandler;
import com.senseidb.search.client.json.JsonField;
import com.senseidb.search.client.json.req.Operator;
import com.senseidb.search.client.json.req.filter.Filter;
import com.senseidb.search.client.json.req.query.Query;
import com.senseidb.search.client.json.req.query.QueryJsonHandler;
import java.util.Arrays;
import java.util.List;

@CustomJsonHandler(value=QueryJsonHandler.class)
public class StringQuery
implements Filter,
Query {
    @JsonField(value="default_field")
    private String defaultField;
    private String query;
    @JsonField(value="default_operator")
    private Operator defaultOperator;
    @JsonField(value="allow_leading_wildCard")
    private Boolean allowLeadingWildCard;
    @JsonField(value="lowercase_expanded_terms")
    private Boolean lowercaseExpandedTerms;
    @JsonField(value="enable_position_increments")
    private Boolean enablePositionIncrements;
    @JsonField(value="fuzzy_prefix_length")
    private String fuzzyPrefixLength;
    @JsonField(value="fuzzy_min_sim")
    private Double fuzzyMinSim;
    @JsonField(value="phrase_slop")
    private Integer phraseSlop;
    private Double boost = 1.0;
    @JsonField(value="auto_generate_phrase_queries")
    private Boolean autoGeneratePhraseQueries;
    private List<String> fields;
    @JsonField(value="use_dis_max")
    private Boolean useDisMax;
    @JsonField(value="tie_breaker")
    private Integer tieBreaker;

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private StringQuery query = new StringQuery();

        public Builder defaultField(String defaultField) {
            this.query.defaultField = defaultField;
            return this;
        }

        public Builder allowLeadingWildCard(boolean allowLeadingWildCard) {
            this.query.allowLeadingWildCard = allowLeadingWildCard;
            return this;
        }

        public Builder defaultOperator(Operator op) {
            this.query.defaultOperator = op;
            return this;
        }

        public Builder lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
            this.query.lowercaseExpandedTerms = lowercaseExpandedTerms;
            return this;
        }

        public Builder enablePositionIncrements(boolean enablePositionIncrements) {
            this.query.enablePositionIncrements = enablePositionIncrements;
            return this;
        }

        public Builder fuzzyPrefixLength(String fuzzyPrefixLength) {
            this.query.fuzzyPrefixLength = fuzzyPrefixLength;
            return this;
        }

        public Builder fuzzyMinSim(double fuzzyMinSim) {
            this.query.fuzzyMinSim = fuzzyMinSim;
            return this;
        }

        public Builder phraseSlop(int phraseSlop) {
            this.query.phraseSlop = phraseSlop;
            return this;
        }

        public Builder boost(double boost) {
            this.query.boost = boost;
            return this;
        }

        public Builder autoGeneratePhraseQueries(boolean autoGeneratePhraseQueries) {
            this.query.autoGeneratePhraseQueries = autoGeneratePhraseQueries;
            return this;
        }

        public Builder fields(String ... fields) {
            this.query.fields = Arrays.asList(fields);
            return this;
        }

        public Builder useDisMax(boolean useDisMax) {
            this.query.useDisMax = useDisMax;
            return this;
        }

        public Builder tieBreaker(int tieBreaker) {
            this.query.tieBreaker = tieBreaker;
            return this;
        }

        public Builder query(String queryParam) {
            this.query.query = queryParam;
            return this;
        }

        public StringQuery build() {
            return this.query;
        }
    }
}

