/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req.query;

import com.senseidb.search.client.json.JsonHandler;
import com.senseidb.search.client.json.JsonSerializer;
import com.senseidb.search.client.json.req.Selection;
import com.senseidb.search.client.json.req.Term;
import com.senseidb.search.client.json.req.Terms;
import com.senseidb.search.client.json.req.filter.Ids;
import com.senseidb.search.client.json.req.query.BoolQuery;
import com.senseidb.search.client.json.req.query.CustomQuery;
import com.senseidb.search.client.json.req.query.DisMax;
import com.senseidb.search.client.json.req.query.FieldAware;
import com.senseidb.search.client.json.req.query.FilteredQuery;
import com.senseidb.search.client.json.req.query.MatchAllQuery;
import com.senseidb.search.client.json.req.query.PathQuery;
import com.senseidb.search.client.json.req.query.Query;
import com.senseidb.search.client.json.req.query.QueryPrefix;
import com.senseidb.search.client.json.req.query.QueryWildcard;
import com.senseidb.search.client.json.req.query.StringQuery;
import com.senseidb.search.client.json.req.query.TextQuery;
import com.senseidb.search.client.json.req.query.span.SpanFirst;
import com.senseidb.search.client.json.req.query.span.SpanNear;
import com.senseidb.search.client.json.req.query.span.SpanNot;
import com.senseidb.search.client.json.req.query.span.SpanOr;
import com.senseidb.search.client.json.req.query.span.SpanTerm;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryJsonHandler
implements JsonHandler<Query> {
    private static Map<Class<? extends Query>, String> typeNames = new HashMap<Class<? extends Query>, String>();

    @Override
    public JSONObject serialize(Query bean) throws JSONException {
        if (bean == null) {
            return null;
        }
        if (!typeNames.containsKey(bean.getClass())) {
            throw new UnsupportedOperationException("Class " + bean.getClass() + " is not supported for serialization by the QueryJsonHandler");
        }
        JSONObject defaultSerialization = (JSONObject)JsonSerializer.serialize(bean, false);
        if (bean instanceof FieldAware) {
            defaultSerialization.remove("field");
            if (bean instanceof SpanTerm && ((SpanTerm)bean).getBoost() == null) {
                SpanTerm spanTerm = (SpanTerm)bean;
                defaultSerialization = new JSONObject().put(spanTerm.getField(), (Object)spanTerm.getValue());
            } else {
                defaultSerialization = new JSONObject().put(((FieldAware)((Object)bean)).getField(), (Object)defaultSerialization);
            }
        }
        if (bean instanceof Selection) {
            defaultSerialization.remove("field");
            defaultSerialization = new JSONObject().put(((Selection)((Object)bean)).getField(), (Object)defaultSerialization);
        }
        return new JSONObject().put(typeNames.get(bean.getClass()), (Object)defaultSerialization);
    }

    @Override
    public Query deserialize(JSONObject json) throws JSONException {
        return null;
    }

    static {
        typeNames.put(StringQuery.class, "query_string");
        typeNames.put(MatchAllQuery.class, "match_all");
        typeNames.put(DisMax.class, "dis_max");
        typeNames.put(QueryPrefix.class, "prefix");
        typeNames.put(QueryWildcard.class, "wildcard");
        typeNames.put(TextQuery.class, "text");
        typeNames.put(SpanFirst.class, "span_first");
        typeNames.put(SpanTerm.class, "span_term");
        typeNames.put(SpanNear.class, "span_near");
        typeNames.put(SpanNot.class, "span_not");
        typeNames.put(SpanOr.class, "span_or");
        typeNames.put(CustomQuery.class, "custom");
        typeNames.put(TextQuery.class, "text");
        typeNames.put(FilteredQuery.class, "filtered");
        typeNames.put(PathQuery.class, "path");
        typeNames.put(BoolQuery.class, "bool");
        typeNames.put(Term.class, "term");
        typeNames.put(Terms.class, "terms");
        typeNames.put(Ids.class, "ids");
        typeNames.put(Selection.Range.class, "range");
    }
}

