/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req.query;

import com.senseidb.search.client.json.req.Operator;
import com.senseidb.search.client.json.req.Selection;
import com.senseidb.search.client.json.req.Term;
import com.senseidb.search.client.json.req.Terms;
import com.senseidb.search.client.json.req.filter.Filter;
import com.senseidb.search.client.json.req.filter.Ids;
import com.senseidb.search.client.json.req.query.BoolQuery;
import com.senseidb.search.client.json.req.query.CustomQuery;
import com.senseidb.search.client.json.req.query.DisMax;
import com.senseidb.search.client.json.req.query.FilteredQuery;
import com.senseidb.search.client.json.req.query.MatchAllQuery;
import com.senseidb.search.client.json.req.query.PathQuery;
import com.senseidb.search.client.json.req.query.Query;
import com.senseidb.search.client.json.req.query.QueryPrefix;
import com.senseidb.search.client.json.req.query.QueryWildcard;
import com.senseidb.search.client.json.req.query.StringQuery;
import com.senseidb.search.client.json.req.query.TextQuery;
import com.senseidb.search.client.json.req.query.span.SpanFirst;
import com.senseidb.search.client.json.req.query.span.SpanNear;
import com.senseidb.search.client.json.req.query.span.SpanNot;
import com.senseidb.search.client.json.req.query.span.SpanOr;
import com.senseidb.search.client.json.req.query.span.SpanTerm;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Queries {
    public static CustomQuery customQuery(String cls, Map<String, String> params, double boost) {
        return new CustomQuery(cls, params, boost);
    }

    public static DisMax disMax(double tieBraker, double boost, Term ... queries) {
        return new DisMax(tieBraker, Arrays.asList(queries), boost);
    }

    public static MatchAllQuery matchAllQuery(double boost) {
        return new MatchAllQuery(boost);
    }

    public static QueryPrefix prefix(String field, String value, double boost) {
        return new QueryPrefix(field, value, boost);
    }

    public static QueryWildcard wildcard(String field, String value, double boost) {
        return new QueryWildcard(field, value, boost);
    }

    public static BoolQuery bool(List<Query> must, List<Query> must_not, List<Query> should, int minimumNumberShouldMatch, double boost, boolean disableCoord) {
        return new BoolQuery(must, must_not, should, minimumNumberShouldMatch, boost, disableCoord);
    }

    public static BoolQuery bool(List<Query> must, List<Query> must_not, List<Query> should, double boost) {
        return new BoolQuery(must, must_not, should, null, boost, null);
    }

    public static StringQuery.Builder stringQueryBuilder() {
        return StringQuery.builder();
    }

    public static StringQuery stringQuery(String query) {
        return StringQuery.builder().query(query).build();
    }

    public static SpanFirst spanFirst(SpanTerm match, int end, double boost) {
        return new SpanFirst(match, end, boost);
    }

    public static SpanNear spanNear(List<SpanTerm> clauses, int slop, boolean inOrder, boolean collectPayloads, double boost) {
        return new SpanNear(clauses, slop, inOrder, collectPayloads, boost);
    }

    public static SpanNot spanNot(SpanTerm include, SpanTerm exclude, double boost) {
        return new SpanNot(include, exclude, boost);
    }

    public static SpanOr spanOr(Double boost, SpanTerm ... clauses) {
        return new SpanOr(Arrays.asList(clauses), boost);
    }

    public static SpanTerm spanTerm(String field, String value) {
        return new SpanTerm(field, value, null);
    }

    public static SpanTerm spanTerm(String field, String value, Double boost) {
        return new SpanTerm(field, value, boost);
    }

    public static TextQuery textQuery(String field, String text, Operator operator, TextQuery.Type type, double boost) {
        return new TextQuery(field, text, operator, type, boost);
    }

    public static TextQuery textQuery(String field, String text, Operator operator, double boost) {
        return new TextQuery(field, text, operator, null, boost);
    }

    public static FilteredQuery filteredQuery(Query query, Filter filter, double boost) {
        return new FilteredQuery(query, filter, boost);
    }

    public static PathQuery path(String field, String name, double boost) {
        return new PathQuery(field, name, boost);
    }

    public static Term term(String field, String value, double boost) {
        return (Term)new Term(value, boost).setField(field);
    }

    public static Terms terms(String field, List<String> values, List<String> excludes, Operator op, int minimumMatch, double boost) {
        return (Terms)new Terms(values, excludes, op, minimumMatch, boost).setField(field);
    }

    public static Ids ids(List<String> values, List<String> excludes, double boost) {
        return new Ids(values, excludes, boost);
    }

    public static Selection.Range range(String field, String from, String to, boolean includeLower, boolean includeUpper, double boost, boolean noOptimize) {
        return (Selection.Range)new Selection.Range(from, to, includeLower, includeUpper, boost, noOptimize).setField(field);
    }

    public static Selection.Range range(String field, String from, String to, boolean includeLower, boolean includeUpper, double boost, boolean noOptimize, String type) {
        return (Selection.Range)new Selection.Range(from, to, includeLower, includeUpper, boost, noOptimize, type).setField(field);
    }
}

