/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req;

import com.senseidb.search.client.json.JsonDeserializer;
import com.senseidb.search.client.json.JsonHandler;
import com.senseidb.search.client.json.JsonSerializer;
import com.senseidb.search.client.json.req.Selection;
import com.senseidb.search.client.json.req.Term;
import com.senseidb.search.client.json.req.Terms;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectionJsonHandler
implements JsonHandler<Selection> {
    public static Map<String, Class<? extends Selection>> selectionClasses = new HashMap<String, Class<? extends Selection>>();

    @Override
    public JSONObject serialize(Selection bean) throws JSONException {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Selection.Custom) {
            JSONObject ret = new JSONObject();
            ret.put("custom", (Object)((Selection.Custom)bean).getCustom());
            return ret;
        }
        JSONObject innerObject = (JSONObject)JsonSerializer.serialize(bean, false);
        JSONObject paramContainer = new JSONObject();
        paramContainer.put(bean.getField(), (Object)innerObject);
        JSONObject ret = new JSONObject();
        ret.put(bean.getClass().getSimpleName().toLowerCase(), (Object)paramContainer);
        return ret;
    }

    @Override
    public Selection deserialize(JSONObject json) throws JSONException {
        Object[] names = JSONObject.getNames((JSONObject)json);
        if (names.length == 0 || !selectionClasses.keySet().contains(names[0])) {
            throw new IllegalStateException("The json object doesn't contain the value from " + Arrays.toString(names));
        }
        Object name = names[0];
        JSONObject innerPart = json.getJSONObject((String)name);
        if ("custom".equals(name)) {
            return Selection.custom(innerPart);
        }
        String fieldName = JSONObject.getNames((JSONObject)innerPart)[0];
        Selection selection = JsonDeserializer.deserialize(selectionClasses.get(name), innerPart.getJSONObject(fieldName), false);
        selection.setField(fieldName);
        return selection;
    }

    static {
        for (Class cls : Arrays.asList(Term.class, Terms.class, Selection.Path.class, Selection.Range.class, Selection.Custom.class)) {
            selectionClasses.put(cls.getSimpleName().toLowerCase(), cls);
        }
    }
}

