/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json.req;

import java.util.HashMap;
import java.util.Map;

public class Facet {
    int max;
    int minHit;
    boolean expand;
    OrderBy order;
    Map<String, String> properties = new HashMap<String, String>();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Facet facet = new Facet();

        public Builder max(int max) {
            this.facet.max = max;
            return this;
        }

        public Builder minHit(int minCount) {
            this.facet.minHit = minCount;
            return this;
        }

        public Builder expand(boolean expand) {
            this.facet.expand = expand;
            return this;
        }

        public Builder orderByHits() {
            this.facet.order = OrderBy.hits;
            return this;
        }

        public Builder orderByVal() {
            this.facet.order = OrderBy.val;
            return this;
        }

        public Builder addProperty(String name, String value) {
            this.facet.properties.put(name, value);
            return this;
        }

        public Facet build() {
            return this.facet;
        }
    }

    public static enum OrderBy {
        hits,
        val;

    }
}

