/*
 * Decompiled with CFR 0.152.
 */
package com.senseidb.search.client.json;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ReflectionUtil {
    public static Set<Annotation> getAnnotations(Class cls) {
        HashSet<Annotation> ret = new HashSet<Annotation>();
        ret.addAll(Arrays.asList(cls.getAnnotations()));
        if (cls.getSuperclass() != null) {
            ret.addAll(ReflectionUtil.getAnnotations(cls.getSuperclass()));
        }
        for (Class<?> intrface : cls.getInterfaces()) {
            ret.addAll(ReflectionUtil.getAnnotations(intrface));
        }
        return ret;
    }

    public static Annotation getAnnotation(Class cls, Class annotationCls) {
        if (cls == null) {
            return null;
        }
        Object ret = cls.getAnnotation(annotationCls);
        if (ret != null) {
            return ret;
        }
        ret = ReflectionUtil.getAnnotation(cls.getSuperclass(), annotationCls);
        if (ret != null) {
            return ret;
        }
        for (Class<?> intrface : cls.getInterfaces()) {
            ret = ReflectionUtil.getAnnotation(intrface, annotationCls);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

