/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.ast;

import griffon.plugins.rmi.DefaultRmiProvider;
import griffon.plugins.rmi.RmiAware;
import griffon.plugins.rmi.RmiContributionHandler;
import griffon.plugins.rmi.RmiProvider;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.core.handlers.RmiAwareConstants;
import org.codehaus.griffon.ast.AbstractASTTransformation;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class RmiAwareASTTransformation
extends AbstractASTTransformation
implements RmiAwareConstants {
    private static final Logger LOG = LoggerFactory.getLogger(RmiAwareASTTransformation.class);
    private static final ClassNode RMI_CONTRIBUTION_HANDLER_CNODE = RmiAwareASTTransformation.makeClassSafe(RmiContributionHandler.class);
    private static final ClassNode RMI_AWARE_CNODE = RmiAwareASTTransformation.makeClassSafe(RmiAware.class);
    private static final ClassNode RMI_PROVIDER_CNODE = RmiAwareASTTransformation.makeClassSafe(RmiProvider.class);
    private static final ClassNode DEFAULT_RMI_PROVIDER_CNODE = RmiAwareASTTransformation.makeClassSafe(DefaultRmiProvider.class);
    private static final String[] DELEGATING_METHODS = new String[]{"withRmi"};

    public static boolean hasRmiAwareAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!RMI_AWARE_CNODE.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.checkNodesForAnnotationAndType(nodes[0], nodes[1]);
        RmiAwareASTTransformation.addRmiContributionIfNeeded(source, (ClassNode)nodes[1]);
    }

    public static void addRmiContributionIfNeeded(SourceUnit source, ClassNode classNode) {
        if (RmiAwareASTTransformation.needsRmiContribution(classNode, source)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + RmiContributionHandler.class.getName() + " into " + classNode.getName());
            }
            RmiAwareASTTransformation.apply(classNode);
        }
    }

    protected static boolean needsRmiContribution(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                found1 = method.getName().equals("withRmi") && method.getParameters().length == 2;
                found2 = method.getName().equals("setRmiProvider") && method.getParameters().length == 1;
                boolean bl = found3 = method.getName().equals("getRmiProvider") && method.getParameters().length == 0;
                if (!found1 || !found2 || !found3) continue;
                return false;
            }
        }
        if (found1 || found2 || found3) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@RmiAware cannot be processed on " + declaringClass.getName() + " because some but not all of methods from " + RmiContributionHandler.class.getName() + " were declared in the current class or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    public static void apply(ClassNode declaringClass) {
        GriffonASTUtils.injectInterface((ClassNode)declaringClass, (ClassNode)RMI_CONTRIBUTION_HANDLER_CNODE);
        FieldNode providerField = declaringClass.addField("this$rmiProvider", 4098, RMI_PROVIDER_CNODE, RmiAwareASTTransformation.defaultRmiProviderInstance());
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("getRmiProvider", 1, RMI_PROVIDER_CNODE, Parameter.EMPTY_ARRAY, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.field((FieldNode)providerField))));
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("setRmiProvider", 1, ClassHelper.VOID_TYPE, GriffonASTUtils.params((Parameter[])new Parameter[]{GriffonASTUtils.param((ClassNode)RMI_PROVIDER_CNODE, (String)"provider")}), GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.block((Statement[])new Statement[]{GriffonASTUtils.ifs_no_return((Expression)GriffonASTUtils.cmp((Expression)GriffonASTUtils.var((String)"provider"), (Expression)ConstantExpression.NULL), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)RmiAwareASTTransformation.defaultRmiProviderInstance()), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)GriffonASTUtils.var((String)"provider")))})));
        for (MethodNode method : RMI_CONTRIBUTION_HANDLER_CNODE.getMethods()) {
            if (Arrays.binarySearch(DELEGATING_METHODS, method.getName()) < 0) continue;
            ArrayList<VariableExpression> variables = new ArrayList<VariableExpression>();
            Parameter[] parameters = new Parameter[method.getParameters().length];
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                parameters[i] = new Parameter(RmiAwareASTTransformation.makeClassSafe((ClassNode)p.getType()), p.getName());
                parameters[i].getType().setGenericsTypes(p.getType().getGenericsTypes());
                variables.add(GriffonASTUtils.var((String)p.getName()));
            }
            ClassNode returnType = RmiAwareASTTransformation.makeClassSafe((ClassNode)method.getReturnType());
            returnType.setGenericsTypes(method.getReturnType().getGenericsTypes());
            returnType.setGenericsPlaceHolder(method.getReturnType().isGenericsPlaceHolder());
            MethodNode newMethod = new MethodNode(method.getName(), 1, returnType, parameters, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.call((Expression)GriffonASTUtils.field((FieldNode)providerField), (String)method.getName(), (ArgumentListExpression)GriffonASTUtils.args(variables))));
            newMethod.setGenericsTypes(method.getGenericsTypes());
            GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)newMethod);
        }
    }

    private static Expression defaultRmiProviderInstance() {
        return GriffonASTUtils.call((ClassNode)DEFAULT_RMI_PROVIDER_CNODE, (String)"getInstance", (ArgumentListExpression)GriffonASTUtils.NO_ARGS);
    }

    static {
        Arrays.sort(DELEGATING_METHODS);
    }
}

