/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.ast;

import griffon.plugins.rest.DefaultRestProvider;
import griffon.plugins.rest.RestAware;
import griffon.plugins.rest.RestContributionHandler;
import griffon.plugins.rest.RestProvider;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.core.handlers.RestAwareConstants;
import org.codehaus.griffon.ast.AbstractASTTransformation;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class RestAwareASTTransformation
extends AbstractASTTransformation
implements RestAwareConstants {
    private static final Logger LOG = LoggerFactory.getLogger(RestAwareASTTransformation.class);
    private static final ClassNode REST_CONTRIBUTION_HANDLER_CNODE = RestAwareASTTransformation.makeClassSafe(RestContributionHandler.class);
    private static final ClassNode REST_AWARE_CNODE = RestAwareASTTransformation.makeClassSafe(RestAware.class);
    private static final ClassNode REST_PROVIDER_CNODE = RestAwareASTTransformation.makeClassSafe(RestProvider.class);
    private static final ClassNode DEFAULT_REST_PROVIDER_CNODE = RestAwareASTTransformation.makeClassSafe(DefaultRestProvider.class);
    private static final String[] DELEGATING_METHODS = new String[]{"withHttp", "withRest", "withAsyncHttp"};

    public static boolean hasRestAwareAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!REST_AWARE_CNODE.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.checkNodesForAnnotationAndType(nodes[0], nodes[1]);
        RestAwareASTTransformation.addRestContributionIfNeeded(source, (ClassNode)nodes[1]);
    }

    public static void addRestContributionIfNeeded(SourceUnit source, ClassNode classNode) {
        if (RestAwareASTTransformation.needsRestContribution(classNode, source)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + RestContributionHandler.class.getName() + " into " + classNode.getName());
            }
            RestAwareASTTransformation.apply(classNode);
        }
    }

    protected static boolean needsRestContribution(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        boolean found4 = false;
        boolean found5 = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                found1 = method.getName().equals("withAsyncHttp") && method.getParameters().length == 2;
                found2 = method.getName().equals("withRest") && method.getParameters().length == 2;
                found3 = method.getName().equals("withHttp") && method.getParameters().length == 2;
                found4 = method.getName().equals("setRestProvider") && method.getParameters().length == 1;
                boolean bl = found5 = method.getName().equals("getRestProvider") && method.getParameters().length == 0;
                if (!found1 || !found2 || !found3) continue;
                return false;
            }
        }
        if (found1 || found2 || found3 || found4 || found5) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@RestAware cannot be processed on " + declaringClass.getName() + " because some but not all of methods from " + RestContributionHandler.class.getName() + " were declared in the current class or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    public static void apply(ClassNode declaringClass) {
        GriffonASTUtils.injectInterface((ClassNode)declaringClass, (ClassNode)REST_CONTRIBUTION_HANDLER_CNODE);
        FieldNode providerField = declaringClass.addField("this$restProvider", 4098, REST_PROVIDER_CNODE, RestAwareASTTransformation.defaultRestProviderInstance());
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("getRestProvider", 1, REST_PROVIDER_CNODE, Parameter.EMPTY_ARRAY, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.field((FieldNode)providerField))));
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("setRestProvider", 1, ClassHelper.VOID_TYPE, GriffonASTUtils.params((Parameter[])new Parameter[]{GriffonASTUtils.param((ClassNode)REST_PROVIDER_CNODE, (String)"provider")}), GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.block((Statement[])new Statement[]{GriffonASTUtils.ifs_no_return((Expression)GriffonASTUtils.cmp((Expression)GriffonASTUtils.var((String)"provider"), (Expression)ConstantExpression.NULL), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)RestAwareASTTransformation.defaultRestProviderInstance()), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)GriffonASTUtils.var((String)"provider")))})));
        for (MethodNode method : REST_CONTRIBUTION_HANDLER_CNODE.getMethods()) {
            if (Arrays.binarySearch(DELEGATING_METHODS, method.getName()) < 0) continue;
            ArrayList<VariableExpression> variables = new ArrayList<VariableExpression>();
            Parameter[] parameters = new Parameter[method.getParameters().length];
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                parameters[i] = new Parameter(RestAwareASTTransformation.makeClassSafe((ClassNode)p.getType()), p.getName());
                parameters[i].getType().setGenericsTypes(p.getType().getGenericsTypes());
                variables.add(GriffonASTUtils.var((String)p.getName()));
            }
            ClassNode returnType = RestAwareASTTransformation.makeClassSafe((ClassNode)method.getReturnType());
            returnType.setGenericsTypes(method.getReturnType().getGenericsTypes());
            returnType.setGenericsPlaceHolder(method.getReturnType().isGenericsPlaceHolder());
            MethodNode newMethod = new MethodNode(method.getName(), 1, returnType, parameters, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.call((Expression)GriffonASTUtils.field((FieldNode)providerField), (String)method.getName(), (ArgumentListExpression)GriffonASTUtils.args(variables))));
            newMethod.setGenericsTypes(method.getGenericsTypes());
            GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)newMethod);
        }
    }

    private static Expression defaultRestProviderInstance() {
        return GriffonASTUtils.call((ClassNode)DEFAULT_REST_PROVIDER_CNODE, (String)"getInstance", (ArgumentListExpression)GriffonASTUtils.NO_ARGS);
    }

    static {
        Arrays.sort(DELEGATING_METHODS);
    }
}

