/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package griffon.plugins.rest;

import java.util.Map;
import groovy.lang.Closure;
import griffon.util.CallableWithArgs;

/**
 * @author Andres Almiray
 */
public interface RestProvider {
    Object withAsyncHttp(Map params, Closure closure);
    
    Object withHttp(Map params, Closure closure);
    
    Object withRest(Map params, Closure closure);
    
    <T> T withAsyncHttp(Map params, CallableWithArgs<T> callable);
    
    <T> T withHttp(Map params, CallableWithArgs<T> callable);
    
    <T> T withRest(Map params, CallableWithArgs<T> callable);
}
